/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.connector.HazelcastWriters;
import com.hazelcast.jet.impl.connector.MapSinkEntryProcessorConfiguration;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.map.EntryProcessor;

public class MapSinkEntryProcessorBuilder<E, K, V, R> {
    private final String mapName;
    private DataConnectionRef dataConnectionRef;
    private ClientConfig clientConfig;
    private FunctionEx<? super E, ? extends K> toKeyFn;
    private FunctionEx<? super E, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn;
    private int maxParallelAsyncOps = 1000;

    public MapSinkEntryProcessorBuilder(String mapName) {
        this.mapName = mapName;
    }

    public MapSinkEntryProcessorBuilder<E, K, V, R> dataConnectionName(DataConnectionRef dataConnectionRef) {
        this.dataConnectionRef = dataConnectionRef;
        return this;
    }

    public MapSinkEntryProcessorBuilder<E, K, V, R> clientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        return this;
    }

    public MapSinkEntryProcessorBuilder<E, K, V, R> toKeyFn(FunctionEx<? super E, ? extends K> toKeyFn) {
        this.toKeyFn = toKeyFn;
        return this;
    }

    public MapSinkEntryProcessorBuilder<E, K, V, R> toEntryProcessorFn(FunctionEx<? super E, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        this.toEntryProcessorFn = toEntryProcessorFn;
        return this;
    }

    public MapSinkEntryProcessorBuilder<E, K, V, R> maxParallelAsyncOps(int maxParallelAsyncOps) {
        this.maxParallelAsyncOps = maxParallelAsyncOps;
        return this;
    }

    public Sink<E> build() {
        MapSinkEntryProcessorConfiguration configuration = new MapSinkEntryProcessorConfiguration(this.mapName);
        configuration.setDataConnectionRef(this.dataConnectionRef);
        configuration.setClientXml(ImdgUtil.asXmlString(this.clientConfig));
        configuration.setToKeyFn(this.toKeyFn);
        configuration.setToEntryProcessorFn(this.toEntryProcessorFn);
        configuration.setMaxParallelAsyncOps(this.maxParallelAsyncOps);
        ProcessorMetaSupplier processorMetaSupplier = HazelcastWriters.updateMapSupplier(configuration);
        return Sinks.fromProcessor(this.geSinkName(), processorMetaSupplier, this.toKeyFn);
    }

    private String geSinkName() {
        if (this.isRemote()) {
            return "remoteMapWithEntryProcessorSink(" + this.mapName + ")";
        }
        return "mapWithEntryProcessorSink(" + this.mapName + ")";
    }

    private boolean isRemote() {
        return this.dataConnectionRef != null || this.clientConfig != null;
    }
}

