/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql;

import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.sql.SqlColumnType;
import javax.annotation.Nonnull;

public final class SqlColumnMetadata {
    private final String name;
    private final SqlColumnType type;
    private final boolean nullable;

    @PrivateApi
    public SqlColumnMetadata(@Nonnull String name, @Nonnull SqlColumnType type, boolean nullable) {
        assert (name != null);
        assert (type != null);
        this.name = name;
        this.type = type;
        this.nullable = nullable;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public SqlColumnType getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlColumnMetadata that = (SqlColumnMetadata)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.nullable == that.nullable && this.type == that.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + Boolean.hashCode(this.nullable);
        return result;
    }

    public String toString() {
        return this.name + " " + this.type;
    }
}

