/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.chat;

import com.github.openjson.JSONObject;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.apache.openmeetings.core.util.ChatWebSocketHelper;
import org.apache.openmeetings.db.dao.basic.ChatDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.ChatMessage;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.MainPanel;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.user.chat.Chat;
import org.apache.openmeetings.web.user.chat.ChatToolbar;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.IAjaxCallListener;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.jquery.ui.plugins.wysiwyg.WysiwygEditor;
import org.wicketstuff.jquery.ui.plugins.wysiwyg.toolbar.IWysiwygToolbar;

public class ChatForm
extends Form<Void> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ChatForm.class);
    private final HiddenField<String> activeTab = new HiddenField("activeTab", (IModel)Model.of((Serializable)((Object)"")));
    @Inject
    private ClientManager cm;
    @Inject
    private ChatDao chatDao;
    @Inject
    private UserDao userDao;
    @Inject
    private RoomDao roomDao;

    public ChatForm(String id) {
        super(id);
        final ChatToolbar toolbar = new ChatToolbar("toolbarContainer", this);
        final WysiwygEditor chatMessage = new WysiwygEditor("chatMessage", (IModel)Model.of((Serializable)((Object)"")), (IWysiwygToolbar)toolbar);
        this.add(new Component[]{toolbar, this.activeTab.add(new Behavior[]{new AjaxFormSubmitBehavior(this, "change"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                toolbar.update(target);
            }
        }}), chatMessage.setOutputMarkupId(true), new AjaxButton("send"){
            private static final long serialVersionUID = 1L;

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(new IAjaxCallListener(){

                    public CharSequence getPrecondition(Component component) {
                        return "return Chat.validate();";
                    }
                });
            }

            private Chat getChat() {
                return (Chat)((Object)this.findParent(Chat.class));
            }

            protected void onSubmit(AjaxRequestTarget target) {
                String txt = chatMessage.getDefaultModelObjectAsString();
                if (Strings.isEmpty((String)txt)) {
                    return;
                }
                ChatMessage m = new ChatMessage();
                m.setMessage(txt);
                m.setSent(new Date());
                m.setFromUser(ChatForm.this.userDao.get(WebSession.getUserId()));
                m.setFromName(ChatForm.this.getClient().getUser().getDisplayName());
                if (!ChatForm.this.process(() -> this.getChat().isShowDashboardChat(), r -> {
                    if (!ChatForm.this.cm.isInRoom(r.getId(), WebSession.getUserId())) {
                        log.error("It seems like we are being hacked!!!!");
                        return false;
                    }
                    m.setToRoom(r);
                    m.setNeedModeration(r.isChatModerated() && !RoomPanel.isModerator(ChatForm.this.cm, m.getFromUser().getId(), r.getId()));
                    return true;
                }, u -> {
                    m.setToUser(u);
                    return true;
                })) {
                    return;
                }
                ChatForm.this.chatDao.update(m);
                JSONObject msg = this.getChat().getMessage(List.of(m));
                if (m.getToRoom() != null) {
                    ChatWebSocketHelper.sendRoom((ChatMessage)m, (JSONObject)msg);
                } else if (m.getToUser() != null) {
                    ChatWebSocketHelper.sendUser((Long)WebSession.getUserId(), (ChatMessage)m, (JSONObject)msg);
                    msg = Chat.getMessage(m.getToUser(), List.of(m));
                    ChatWebSocketHelper.sendUser((Long)m.getToUser().getId(), (ChatMessage)m, (JSONObject)msg);
                } else {
                    ChatWebSocketHelper.sendAll((ChatMessage)m, (JSONObject)msg);
                }
                chatMessage.setDefaultModelObject((Object)"");
                target.appendJavaScript((CharSequence)"Chat.clean();");
            }
        }});
    }

    private Client getClient() {
        return ((MainPanel)((Object)this.findParent(MainPanel.class))).getClient();
    }

    public String getScope() {
        return (String)this.activeTab.getModelObject();
    }

    boolean process(BooleanSupplier processAll, Predicate<Room> processRoom, Predicate<User> processUser) {
        try {
            User u;
            String scope = this.getScope();
            if (Strings.isEmpty((String)scope) || "chatTab-all".equals(scope)) {
                return processAll.getAsBoolean();
            }
            if (scope.startsWith("chatTab-r")) {
                Room r = (Room)this.roomDao.get(Long.parseLong(scope.substring("chatTab-r".length())));
                if (r != null) {
                    return processRoom.test(r);
                }
            } else if (scope.startsWith("chatTab-u") && (u = (User)this.userDao.get(Long.parseLong(scope.substring("chatTab-u".length())))) != null) {
                return processUser.test(u);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

