/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredFile {
    private static final Logger log = LoggerFactory.getLogger(StoredFile.class);
    private static final String MIME_AUDIO = "audio";
    private static final String MIME_VIDEO = "video";
    private static final String MIME_IMAGE = "image";
    private static final String MIME_TEXT = "text";
    private static final String MIME_APP = "application";
    private static final Set<MediaType> CONVERT_TYPES = Set.of(MediaType.application((String)"x-tika-msoffice"), MediaType.application((String)"x-tika-ooxml"), MediaType.application((String)"msword"), MediaType.application((String)"vnd.wordperfect"), MediaType.application((String)"rtf"));
    private static final MediaType MIME_PNG = MediaType.parse((String)"image/png");
    private static final Set<MediaType> PDF_TYPES = Set.of(MediaType.application((String)"pdf"), MediaType.application((String)"postscript"));
    private static final Set<MediaType> CHART_TYPES = new HashSet<MediaType>();
    private static final Set<MediaType> AS_IS_TYPES = Set.of(MIME_PNG);
    private static final String ACCEPT_STRING;
    private static TikaConfig tika;
    private String name;
    private String ext;
    private MediaType mime;

    public StoredFile(String fullname, InputStream is) {
        this(fullname, null, is);
    }

    public StoredFile(String name, String ext, InputStream is) {
        this.init(name, ext, is);
    }

    public StoredFile(String fullname, File f) throws IOException {
        this(fullname, null, f);
    }

    public StoredFile(String name, String ext, File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);){
            this.init(name, ext, fis);
        }
    }

    private void init(String inName, String inExt, InputStream is) {
        if (Strings.isEmpty((String)inExt)) {
            int idx = inName.lastIndexOf(46);
            this.name = idx < 0 ? inName : inName.substring(0, idx);
            this.ext = OmFileHelper.getFileExt(inName);
        } else {
            this.name = inName;
            this.ext = inExt.toLowerCase(Locale.ROOT);
        }
        Metadata md = new Metadata();
        md.add("resourceName", String.format("%s.%s", this.name, this.ext));
        try {
            this.mime = tika.getDetector().detect((InputStream)(is == null ? null : TikaInputStream.get((InputStream)is)), md);
        }
        catch (Throwable e) {
            this.mime = null;
            log.error("Unexpected exception while detecting mime type", e);
        }
    }

    public static String getAcceptAttr() {
        return ACCEPT_STRING;
    }

    public boolean isOffice() {
        if (this.mime == null) {
            return false;
        }
        return MIME_TEXT.equals(this.mime.getType()) || MIME_APP.equals(this.mime.getType()) && (this.mime.getSubtype().startsWith("vnd.oasis.opendocument") || this.mime.getSubtype().startsWith("vnd.sun.xml") || this.mime.getSubtype().startsWith("vnd.stardivision") || this.mime.getSubtype().startsWith("x-star") || this.mime.getSubtype().startsWith("vnd.ms-") || this.mime.getSubtype().startsWith("vnd.openxmlformats-officedocument")) || CONVERT_TYPES.contains(this.mime);
    }

    public boolean isPresentation() {
        return this.isOffice() || this.isPdf();
    }

    public boolean isPdf() {
        if (this.mime == null) {
            return false;
        }
        return PDF_TYPES.contains(this.mime);
    }

    public boolean isPng() {
        if (this.mime == null) {
            return false;
        }
        return MIME_PNG.equals((Object)this.mime);
    }

    public boolean isImage() {
        if (this.mime == null) {
            return false;
        }
        return MIME_IMAGE.equals(this.mime.getType());
    }

    public boolean isAudio() {
        if (this.mime == null) {
            return false;
        }
        return MIME_AUDIO.equals(this.mime.getType());
    }

    public boolean isVideo() {
        if (this.mime == null) {
            return false;
        }
        return this.isAudio() || MIME_VIDEO.equals(this.mime.getType());
    }

    public boolean isChart() {
        if (this.mime == null) {
            return false;
        }
        return CHART_TYPES.contains(this.mime);
    }

    public boolean isAsIs() {
        if (this.mime == null) {
            return false;
        }
        return AS_IS_TYPES.contains(this.mime);
    }

    public String getName() {
        return this.name;
    }

    public String getExt() {
        return this.ext;
    }

    public MediaType getMime() {
        return this.mime;
    }

    static {
        LinkedHashSet<MediaType> types = new LinkedHashSet<MediaType>();
        types.addAll(CONVERT_TYPES);
        types.addAll(PDF_TYPES);
        StringBuilder sb = new StringBuilder("audio/*,video/*,image/*,text/*");
        sb.append(",application/vnd.oasis.opendocument.*");
        sb.append(",application/vnd.sun.xml.*");
        sb.append(",application/vnd.stardivision.*");
        sb.append(",application/x-star*");
        for (MediaType mt : types) {
            sb.append(',').append(mt.toString());
        }
        ACCEPT_STRING = sb.toString();
        try {
            tika = new TikaConfig();
        }
        catch (IOException | TikaException e) {
            log.error("Unexpected exception while initializing TIKA", e);
            throw new RuntimeException(e);
        }
    }
}

