/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.transport.jsonrpc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.kurento.client.internal.server.ProtocolException;
import org.kurento.client.internal.server.RomServer;
import org.kurento.jsonrpc.DefaultJsonRpcHandler;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.Props;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RomServerJsonRpcHandler
extends DefaultJsonRpcHandler<JsonObject> {
    private static Logger LOG = LoggerFactory.getLogger(RomServerJsonRpcHandler.class);
    private final RomServer server;

    public RomServerJsonRpcHandler(String packageName, String classSuffix) {
        this.server = new RomServer(packageName, classSuffix);
    }

    public void handleRequest(Transaction transaction, Request<JsonObject> request) throws Exception {
        try {
            String method;
            JsonObject params = (JsonObject)request.getParams();
            switch (method = request.getMethod()) {
                case "invoke": {
                    String objectRef = this.getAsString(params, "object", "object reference");
                    String operationName = this.getAsString(params, "operation", "method to be invoked");
                    JsonObject operationParams = params.getAsJsonObject("operationParams");
                    this.handleInvokeCommand(transaction, objectRef, operationName, operationParams);
                    break;
                }
                case "release": {
                    String objectReleaseRef = this.getAsString(params, "object", "object reference to be released");
                    this.handleReleaseCommand(transaction, objectReleaseRef);
                    break;
                }
                case "create": {
                    String type = this.getAsString(params, "type", "RemoteClass of the object to be created");
                    this.handleCreateCommand(transaction, type, params.getAsJsonObject("constructorParams"));
                    break;
                }
                default: {
                    LOG.warn("Unknown request method '{}'", (Object)method);
                    break;
                }
            }
        }
        catch (ProtocolException e) {
            try {
                transaction.sendError((Throwable)((Object)e));
            }
            catch (IOException ex) {
                LOG.warn("Exception while sending a response", (Throwable)((Object)e));
            }
        }
        catch (IOException e) {
            LOG.warn("Exception while sending a response", (Throwable)e);
        }
    }

    private String getAsString(JsonObject jsonObject, String propName, String propertyDescription) {
        if (jsonObject == null) {
            throw new ProtocolException("There are no params in the request");
        }
        JsonElement element = jsonObject.get(propName);
        if (element == null) {
            throw new ProtocolException("It is necessary a property '" + propName + "' with " + propertyDescription);
        }
        return element.getAsString();
    }

    private void handleCreateCommand(Transaction transaction, String type, JsonObject constructorParams) throws IOException {
        String result = this.server.create(type, (Props)JsonUtils.fromJson((JsonElement)constructorParams, Props.class));
        transaction.sendResponse((Object)result);
    }

    private void handleReleaseCommand(Transaction transaction, String objectRef) {
        this.server.release(objectRef);
    }

    private void handleInvokeCommand(Transaction transaction, String objectRef, String operationName, JsonObject operationParams) throws IOException {
        Object result = this.server.invoke(objectRef, operationName, (Props)JsonUtils.fromJson((JsonElement)operationParams, Props.class), Object.class);
        transaction.sendResponse(result);
    }
}

