/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.methods;

import com.github.caldav4j.model.request.CalendarRequest;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPutMethod
extends HttpPut {
    private static final Logger log = LoggerFactory.getLogger(HttpPutMethod.class);

    public HttpPutMethod(URI uri, CalendarRequest calendarRequest, CalendarOutputter calendarOutputter) {
        super(uri);
        this.addRequestHeaders(calendarRequest);
        this.generateRequestBody(calendarRequest, calendarOutputter);
    }

    public HttpPutMethod(String uri, CalendarRequest calendarRequest, CalendarOutputter calendarOutputter) {
        this(URI.create(uri), calendarRequest, calendarOutputter);
    }

    protected void generateRequestBody(CalendarRequest calendarRequest, CalendarOutputter calendarOutputter) {
        Calendar calendar = calendarRequest.getCalendar();
        if (calendar != null) {
            StringWriter writer = new StringWriter();
            try {
                calendarOutputter.output(calendar, (Writer)writer);
                ContentType ct = ContentType.create((String)"text/calendar", (Charset)calendarRequest.getCharset());
                this.setEntity((HttpEntity)new StringEntity(writer.toString(), ct));
            }
            catch (UnsupportedCharsetException e) {
                log.error("Unsupported encoding in event" + writer.toString());
                throw new RuntimeException("Problem generating calendar. ", e);
            }
            catch (Exception e) {
                log.error("Problem generating calendar: ", (Throwable)e);
                throw new RuntimeException("Problem generating calendar. ", e);
            }
        }
    }

    protected void addRequestHeaders(CalendarRequest calendarRequest) {
        boolean ifMatch = calendarRequest.isIfMatch();
        boolean ifNoneMatch = calendarRequest.isIfNoneMatch();
        if (ifMatch || ifNoneMatch) {
            String name = ifMatch ? "If-Match" : "If-None-Match";
            String value = null;
            if (calendarRequest.isAllEtags()) {
                value = "*";
            } else {
                StringBuilder buf = new StringBuilder();
                for (String etag : calendarRequest.getEtags()) {
                    buf.append(etag);
                }
                value = buf.toString();
            }
            this.addHeader(name, value);
        }
    }

    public boolean succeeded(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status <= 299;
    }
}

