/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLogDataLogDataEntryBitStringValue is the corresponding interface of BACnetLogDataLogDataEntryBitStringValue
type BACnetLogDataLogDataEntryBitStringValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetLogDataLogDataEntry
	// GetBitStringValue returns BitStringValue (property field)
	GetBitStringValue() BACnetContextTagBitString
	// IsBACnetLogDataLogDataEntryBitStringValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLogDataLogDataEntryBitStringValue()
	// CreateBuilder creates a BACnetLogDataLogDataEntryBitStringValueBuilder
	CreateBACnetLogDataLogDataEntryBitStringValueBuilder() BACnetLogDataLogDataEntryBitStringValueBuilder
}

// _BACnetLogDataLogDataEntryBitStringValue is the data-structure of this message
type _BACnetLogDataLogDataEntryBitStringValue struct {
	BACnetLogDataLogDataEntryContract
	BitStringValue BACnetContextTagBitString
}

var _ BACnetLogDataLogDataEntryBitStringValue = (*_BACnetLogDataLogDataEntryBitStringValue)(nil)
var _ BACnetLogDataLogDataEntryRequirements = (*_BACnetLogDataLogDataEntryBitStringValue)(nil)

// NewBACnetLogDataLogDataEntryBitStringValue factory function for _BACnetLogDataLogDataEntryBitStringValue
func NewBACnetLogDataLogDataEntryBitStringValue(peekedTagHeader BACnetTagHeader, bitStringValue BACnetContextTagBitString) *_BACnetLogDataLogDataEntryBitStringValue {
	if bitStringValue == nil {
		panic("bitStringValue of type BACnetContextTagBitString for BACnetLogDataLogDataEntryBitStringValue must not be nil")
	}
	_result := &_BACnetLogDataLogDataEntryBitStringValue{
		BACnetLogDataLogDataEntryContract: NewBACnetLogDataLogDataEntry(peekedTagHeader),
		BitStringValue:                    bitStringValue,
	}
	_result.BACnetLogDataLogDataEntryContract.(*_BACnetLogDataLogDataEntry)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLogDataLogDataEntryBitStringValueBuilder is a builder for BACnetLogDataLogDataEntryBitStringValue
type BACnetLogDataLogDataEntryBitStringValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(bitStringValue BACnetContextTagBitString) BACnetLogDataLogDataEntryBitStringValueBuilder
	// WithBitStringValue adds BitStringValue (property field)
	WithBitStringValue(BACnetContextTagBitString) BACnetLogDataLogDataEntryBitStringValueBuilder
	// WithBitStringValueBuilder adds BitStringValue (property field) which is build by the builder
	WithBitStringValueBuilder(func(BACnetContextTagBitStringBuilder) BACnetContextTagBitStringBuilder) BACnetLogDataLogDataEntryBitStringValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetLogDataLogDataEntryBuilder
	// Build builds the BACnetLogDataLogDataEntryBitStringValue or returns an error if something is wrong
	Build() (BACnetLogDataLogDataEntryBitStringValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLogDataLogDataEntryBitStringValue
}

// NewBACnetLogDataLogDataEntryBitStringValueBuilder() creates a BACnetLogDataLogDataEntryBitStringValueBuilder
func NewBACnetLogDataLogDataEntryBitStringValueBuilder() BACnetLogDataLogDataEntryBitStringValueBuilder {
	return &_BACnetLogDataLogDataEntryBitStringValueBuilder{_BACnetLogDataLogDataEntryBitStringValue: new(_BACnetLogDataLogDataEntryBitStringValue)}
}

type _BACnetLogDataLogDataEntryBitStringValueBuilder struct {
	*_BACnetLogDataLogDataEntryBitStringValue

	parentBuilder *_BACnetLogDataLogDataEntryBuilder

	collectedErr []error
}

var _ (BACnetLogDataLogDataEntryBitStringValueBuilder) = (*_BACnetLogDataLogDataEntryBitStringValueBuilder)(nil)

func (b *_BACnetLogDataLogDataEntryBitStringValueBuilder) setParent(contract BACnetLogDataLogDataEntryContract) {
	b.BACnetLogDataLogDataEntryContract = contract
	contract.(*_BACnetLogDataLogDataEntry)._SubType = b._BACnetLogDataLogDataEntryBitStringValue
}

func (b *_BACnetLogDataLogDataEntryBitStringValueBuilder) WithMandatoryFields(bitStringValue BACnetContextTagBitString) BACnetLogDataLogDataEntryBitStringValueBuilder {
	return b.WithBitStringValue(bitStringValue)
}

func (b *_BACnetLogDataLogDataEntryBitStringValueBuilder) WithBitStringValue(bitStringValue BACnetContextTagBitString) BACnetLogDataLogDataEntryBitStringValueBuilder {
	b.BitStringValue = bitStringValue
	return b
}

func (b *_BACnetLogDataLogDataEntryBitStringValueBuilder) WithBitStringValueBuilder(builderSupplier func(BACnetContextTagBitStringBuilder) BACnetContextTagBitStringBuilder) BACnetLogDataLogDataEntryBitStringValueBuilder {
	builder := builderSupplier(b.BitStringValue.CreateBACnetContextTagBitStringBuilder())
	var err error
	b.BitStringValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagBitStringBuilder failed"))
	}
	return b
}

func (b *_BACnetLogDataLogDataEntryBitStringValueBuilder) Build() (BACnetLogDataLogDataEntryBitStringValue, error) {
	if b.BitStringValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'bitStringValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetLogDataLogDataEntryBitStringValue.deepCopy(), nil
}

func (b *_BACnetLogDataLogDataEntryBitStringValueBuilder) MustBuild() BACnetLogDataLogDataEntryBitStringValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLogDataLogDataEntryBitStringValueBuilder) Done() BACnetLogDataLogDataEntryBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetLogDataLogDataEntryBuilder().(*_BACnetLogDataLogDataEntryBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetLogDataLogDataEntryBitStringValueBuilder) buildForBACnetLogDataLogDataEntry() (BACnetLogDataLogDataEntry, error) {
	return b.Build()
}

func (b *_BACnetLogDataLogDataEntryBitStringValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLogDataLogDataEntryBitStringValueBuilder().(*_BACnetLogDataLogDataEntryBitStringValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetLogDataLogDataEntryBitStringValueBuilder creates a BACnetLogDataLogDataEntryBitStringValueBuilder
func (b *_BACnetLogDataLogDataEntryBitStringValue) CreateBACnetLogDataLogDataEntryBitStringValueBuilder() BACnetLogDataLogDataEntryBitStringValueBuilder {
	if b == nil {
		return NewBACnetLogDataLogDataEntryBitStringValueBuilder()
	}
	return &_BACnetLogDataLogDataEntryBitStringValueBuilder{_BACnetLogDataLogDataEntryBitStringValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetLogDataLogDataEntryBitStringValue) GetParent() BACnetLogDataLogDataEntryContract {
	return m.BACnetLogDataLogDataEntryContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLogDataLogDataEntryBitStringValue) GetBitStringValue() BACnetContextTagBitString {
	return m.BitStringValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLogDataLogDataEntryBitStringValue(structType any) BACnetLogDataLogDataEntryBitStringValue {
	if casted, ok := structType.(BACnetLogDataLogDataEntryBitStringValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLogDataLogDataEntryBitStringValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLogDataLogDataEntryBitStringValue) GetTypeName() string {
	return "BACnetLogDataLogDataEntryBitStringValue"
}

func (m *_BACnetLogDataLogDataEntryBitStringValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetLogDataLogDataEntryContract.(*_BACnetLogDataLogDataEntry).getLengthInBits(ctx))

	// Simple field (bitStringValue)
	lengthInBits += m.BitStringValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetLogDataLogDataEntryBitStringValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetLogDataLogDataEntryBitStringValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetLogDataLogDataEntry) (__bACnetLogDataLogDataEntryBitStringValue BACnetLogDataLogDataEntryBitStringValue, err error) {
	m.BACnetLogDataLogDataEntryContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLogDataLogDataEntryBitStringValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLogDataLogDataEntryBitStringValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	bitStringValue, err := ReadSimpleField[BACnetContextTagBitString](ctx, "bitStringValue", ReadComplex[BACnetContextTagBitString](BACnetContextTagParseWithBufferProducer[BACnetContextTagBitString]((uint8)(uint8(5)), (BACnetDataType)(BACnetDataType_BIT_STRING)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bitStringValue' field"))
	}
	m.BitStringValue = bitStringValue

	if closeErr := readBuffer.CloseContext("BACnetLogDataLogDataEntryBitStringValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLogDataLogDataEntryBitStringValue")
	}

	return m, nil
}

func (m *_BACnetLogDataLogDataEntryBitStringValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLogDataLogDataEntryBitStringValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetLogDataLogDataEntryBitStringValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetLogDataLogDataEntryBitStringValue")
		}

		if err := WriteSimpleField[BACnetContextTagBitString](ctx, "bitStringValue", m.GetBitStringValue(), WriteComplex[BACnetContextTagBitString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'bitStringValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetLogDataLogDataEntryBitStringValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetLogDataLogDataEntryBitStringValue")
		}
		return nil
	}
	return m.BACnetLogDataLogDataEntryContract.(*_BACnetLogDataLogDataEntry).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetLogDataLogDataEntryBitStringValue) IsBACnetLogDataLogDataEntryBitStringValue() {}

func (m *_BACnetLogDataLogDataEntryBitStringValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLogDataLogDataEntryBitStringValue) deepCopy() *_BACnetLogDataLogDataEntryBitStringValue {
	if m == nil {
		return nil
	}
	_BACnetLogDataLogDataEntryBitStringValueCopy := &_BACnetLogDataLogDataEntryBitStringValue{
		m.BACnetLogDataLogDataEntryContract.(*_BACnetLogDataLogDataEntry).deepCopy(),
		utils.DeepCopy[BACnetContextTagBitString](m.BitStringValue),
	}
	_BACnetLogDataLogDataEntryBitStringValueCopy.BACnetLogDataLogDataEntryContract.(*_BACnetLogDataLogDataEntry)._SubType = m
	return _BACnetLogDataLogDataEntryBitStringValueCopy
}

func (m *_BACnetLogDataLogDataEntryBitStringValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
