/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetNotificationParametersExtendedParameters is the corresponding interface of BACnetNotificationParametersExtendedParameters
type BACnetNotificationParametersExtendedParameters interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetNullValue returns NullValue (property field)
	GetNullValue() BACnetApplicationTagNull
	// GetRealValue returns RealValue (property field)
	GetRealValue() BACnetApplicationTagReal
	// GetUnsignedValue returns UnsignedValue (property field)
	GetUnsignedValue() BACnetApplicationTagUnsignedInteger
	// GetBooleanValue returns BooleanValue (property field)
	GetBooleanValue() BACnetApplicationTagBoolean
	// GetIntegerValue returns IntegerValue (property field)
	GetIntegerValue() BACnetApplicationTagSignedInteger
	// GetDoubleValue returns DoubleValue (property field)
	GetDoubleValue() BACnetApplicationTagDouble
	// GetOctetStringValue returns OctetStringValue (property field)
	GetOctetStringValue() BACnetApplicationTagOctetString
	// GetCharacterStringValue returns CharacterStringValue (property field)
	GetCharacterStringValue() BACnetApplicationTagCharacterString
	// GetBitStringValue returns BitStringValue (property field)
	GetBitStringValue() BACnetApplicationTagBitString
	// GetEnumeratedValue returns EnumeratedValue (property field)
	GetEnumeratedValue() BACnetApplicationTagEnumerated
	// GetDateValue returns DateValue (property field)
	GetDateValue() BACnetApplicationTagDate
	// GetTimeValue returns TimeValue (property field)
	GetTimeValue() BACnetApplicationTagTime
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetApplicationTagObjectIdentifier
	// GetReference returns Reference (property field)
	GetReference() BACnetDeviceObjectPropertyReferenceEnclosed
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// GetIsOpeningTag returns IsOpeningTag (virtual field)
	GetIsOpeningTag() bool
	// GetIsClosingTag returns IsClosingTag (virtual field)
	GetIsClosingTag() bool
	// IsBACnetNotificationParametersExtendedParameters is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetNotificationParametersExtendedParameters()
	// CreateBuilder creates a BACnetNotificationParametersExtendedParametersBuilder
	CreateBACnetNotificationParametersExtendedParametersBuilder() BACnetNotificationParametersExtendedParametersBuilder
}

// _BACnetNotificationParametersExtendedParameters is the data-structure of this message
type _BACnetNotificationParametersExtendedParameters struct {
	OpeningTag           BACnetOpeningTag
	PeekedTagHeader      BACnetTagHeader
	NullValue            BACnetApplicationTagNull
	RealValue            BACnetApplicationTagReal
	UnsignedValue        BACnetApplicationTagUnsignedInteger
	BooleanValue         BACnetApplicationTagBoolean
	IntegerValue         BACnetApplicationTagSignedInteger
	DoubleValue          BACnetApplicationTagDouble
	OctetStringValue     BACnetApplicationTagOctetString
	CharacterStringValue BACnetApplicationTagCharacterString
	BitStringValue       BACnetApplicationTagBitString
	EnumeratedValue      BACnetApplicationTagEnumerated
	DateValue            BACnetApplicationTagDate
	TimeValue            BACnetApplicationTagTime
	ObjectIdentifier     BACnetApplicationTagObjectIdentifier
	Reference            BACnetDeviceObjectPropertyReferenceEnclosed
	ClosingTag           BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ BACnetNotificationParametersExtendedParameters = (*_BACnetNotificationParametersExtendedParameters)(nil)

// NewBACnetNotificationParametersExtendedParameters factory function for _BACnetNotificationParametersExtendedParameters
func NewBACnetNotificationParametersExtendedParameters(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, nullValue BACnetApplicationTagNull, realValue BACnetApplicationTagReal, unsignedValue BACnetApplicationTagUnsignedInteger, booleanValue BACnetApplicationTagBoolean, integerValue BACnetApplicationTagSignedInteger, doubleValue BACnetApplicationTagDouble, octetStringValue BACnetApplicationTagOctetString, characterStringValue BACnetApplicationTagCharacterString, bitStringValue BACnetApplicationTagBitString, enumeratedValue BACnetApplicationTagEnumerated, dateValue BACnetApplicationTagDate, timeValue BACnetApplicationTagTime, objectIdentifier BACnetApplicationTagObjectIdentifier, reference BACnetDeviceObjectPropertyReferenceEnclosed, closingTag BACnetClosingTag, tagNumber uint8) *_BACnetNotificationParametersExtendedParameters {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetNotificationParametersExtendedParameters must not be nil")
	}
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetNotificationParametersExtendedParameters must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetNotificationParametersExtendedParameters must not be nil")
	}
	return &_BACnetNotificationParametersExtendedParameters{OpeningTag: openingTag, PeekedTagHeader: peekedTagHeader, NullValue: nullValue, RealValue: realValue, UnsignedValue: unsignedValue, BooleanValue: booleanValue, IntegerValue: integerValue, DoubleValue: doubleValue, OctetStringValue: octetStringValue, CharacterStringValue: characterStringValue, BitStringValue: bitStringValue, EnumeratedValue: enumeratedValue, DateValue: dateValue, TimeValue: timeValue, ObjectIdentifier: objectIdentifier, Reference: reference, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetNotificationParametersExtendedParametersBuilder is a builder for BACnetNotificationParametersExtendedParameters
type BACnetNotificationParametersExtendedParametersBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetNotificationParametersExtendedParametersBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetNotificationParametersExtendedParametersBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetNotificationParametersExtendedParametersBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithNullValue adds NullValue (property field)
	WithOptionalNullValue(BACnetApplicationTagNull) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalNullValueBuilder adds NullValue (property field) which is build by the builder
	WithOptionalNullValueBuilder(func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithRealValue adds RealValue (property field)
	WithOptionalRealValue(BACnetApplicationTagReal) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalRealValueBuilder adds RealValue (property field) which is build by the builder
	WithOptionalRealValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithUnsignedValue adds UnsignedValue (property field)
	WithOptionalUnsignedValue(BACnetApplicationTagUnsignedInteger) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalUnsignedValueBuilder adds UnsignedValue (property field) which is build by the builder
	WithOptionalUnsignedValueBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithBooleanValue adds BooleanValue (property field)
	WithOptionalBooleanValue(BACnetApplicationTagBoolean) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalBooleanValueBuilder adds BooleanValue (property field) which is build by the builder
	WithOptionalBooleanValueBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithIntegerValue adds IntegerValue (property field)
	WithOptionalIntegerValue(BACnetApplicationTagSignedInteger) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalIntegerValueBuilder adds IntegerValue (property field) which is build by the builder
	WithOptionalIntegerValueBuilder(func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithDoubleValue adds DoubleValue (property field)
	WithOptionalDoubleValue(BACnetApplicationTagDouble) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalDoubleValueBuilder adds DoubleValue (property field) which is build by the builder
	WithOptionalDoubleValueBuilder(func(BACnetApplicationTagDoubleBuilder) BACnetApplicationTagDoubleBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithOctetStringValue adds OctetStringValue (property field)
	WithOptionalOctetStringValue(BACnetApplicationTagOctetString) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalOctetStringValueBuilder adds OctetStringValue (property field) which is build by the builder
	WithOptionalOctetStringValueBuilder(func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithCharacterStringValue adds CharacterStringValue (property field)
	WithOptionalCharacterStringValue(BACnetApplicationTagCharacterString) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalCharacterStringValueBuilder adds CharacterStringValue (property field) which is build by the builder
	WithOptionalCharacterStringValueBuilder(func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithBitStringValue adds BitStringValue (property field)
	WithOptionalBitStringValue(BACnetApplicationTagBitString) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalBitStringValueBuilder adds BitStringValue (property field) which is build by the builder
	WithOptionalBitStringValueBuilder(func(BACnetApplicationTagBitStringBuilder) BACnetApplicationTagBitStringBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithEnumeratedValue adds EnumeratedValue (property field)
	WithOptionalEnumeratedValue(BACnetApplicationTagEnumerated) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalEnumeratedValueBuilder adds EnumeratedValue (property field) which is build by the builder
	WithOptionalEnumeratedValueBuilder(func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithDateValue adds DateValue (property field)
	WithOptionalDateValue(BACnetApplicationTagDate) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalDateValueBuilder adds DateValue (property field) which is build by the builder
	WithOptionalDateValueBuilder(func(BACnetApplicationTagDateBuilder) BACnetApplicationTagDateBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithTimeValue adds TimeValue (property field)
	WithOptionalTimeValue(BACnetApplicationTagTime) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalTimeValueBuilder adds TimeValue (property field) which is build by the builder
	WithOptionalTimeValueBuilder(func(BACnetApplicationTagTimeBuilder) BACnetApplicationTagTimeBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithOptionalObjectIdentifier(BACnetApplicationTagObjectIdentifier) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithOptionalObjectIdentifierBuilder(func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithReference adds Reference (property field)
	WithOptionalReference(BACnetDeviceObjectPropertyReferenceEnclosed) BACnetNotificationParametersExtendedParametersBuilder
	// WithOptionalReferenceBuilder adds Reference (property field) which is build by the builder
	WithOptionalReferenceBuilder(func(BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetNotificationParametersExtendedParametersBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetNotificationParametersExtendedParametersBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetNotificationParametersExtendedParametersBuilder
	// Build builds the BACnetNotificationParametersExtendedParameters or returns an error if something is wrong
	Build() (BACnetNotificationParametersExtendedParameters, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetNotificationParametersExtendedParameters
}

// NewBACnetNotificationParametersExtendedParametersBuilder() creates a BACnetNotificationParametersExtendedParametersBuilder
func NewBACnetNotificationParametersExtendedParametersBuilder() BACnetNotificationParametersExtendedParametersBuilder {
	return &_BACnetNotificationParametersExtendedParametersBuilder{_BACnetNotificationParametersExtendedParameters: new(_BACnetNotificationParametersExtendedParameters)}
}

type _BACnetNotificationParametersExtendedParametersBuilder struct {
	*_BACnetNotificationParametersExtendedParameters

	collectedErr []error
}

var _ (BACnetNotificationParametersExtendedParametersBuilder) = (*_BACnetNotificationParametersExtendedParametersBuilder)(nil)

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetNotificationParametersExtendedParametersBuilder {
	return b.WithOpeningTag(openingTag).WithPeekedTagHeader(peekedTagHeader).WithClosingTag(closingTag)
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetNotificationParametersExtendedParametersBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetNotificationParametersExtendedParametersBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalNullValue(nullValue BACnetApplicationTagNull) BACnetNotificationParametersExtendedParametersBuilder {
	b.NullValue = nullValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalNullValueBuilder(builderSupplier func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.NullValue.CreateBACnetApplicationTagNullBuilder())
	var err error
	b.NullValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagNullBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalRealValue(realValue BACnetApplicationTagReal) BACnetNotificationParametersExtendedParametersBuilder {
	b.RealValue = realValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalRealValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.RealValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.RealValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalUnsignedValue(unsignedValue BACnetApplicationTagUnsignedInteger) BACnetNotificationParametersExtendedParametersBuilder {
	b.UnsignedValue = unsignedValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalUnsignedValueBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.UnsignedValue.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.UnsignedValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalBooleanValue(booleanValue BACnetApplicationTagBoolean) BACnetNotificationParametersExtendedParametersBuilder {
	b.BooleanValue = booleanValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalBooleanValueBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.BooleanValue.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.BooleanValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalIntegerValue(integerValue BACnetApplicationTagSignedInteger) BACnetNotificationParametersExtendedParametersBuilder {
	b.IntegerValue = integerValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalIntegerValueBuilder(builderSupplier func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.IntegerValue.CreateBACnetApplicationTagSignedIntegerBuilder())
	var err error
	b.IntegerValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagSignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalDoubleValue(doubleValue BACnetApplicationTagDouble) BACnetNotificationParametersExtendedParametersBuilder {
	b.DoubleValue = doubleValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalDoubleValueBuilder(builderSupplier func(BACnetApplicationTagDoubleBuilder) BACnetApplicationTagDoubleBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.DoubleValue.CreateBACnetApplicationTagDoubleBuilder())
	var err error
	b.DoubleValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagDoubleBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalOctetStringValue(octetStringValue BACnetApplicationTagOctetString) BACnetNotificationParametersExtendedParametersBuilder {
	b.OctetStringValue = octetStringValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalOctetStringValueBuilder(builderSupplier func(BACnetApplicationTagOctetStringBuilder) BACnetApplicationTagOctetStringBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.OctetStringValue.CreateBACnetApplicationTagOctetStringBuilder())
	var err error
	b.OctetStringValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagOctetStringBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalCharacterStringValue(characterStringValue BACnetApplicationTagCharacterString) BACnetNotificationParametersExtendedParametersBuilder {
	b.CharacterStringValue = characterStringValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalCharacterStringValueBuilder(builderSupplier func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.CharacterStringValue.CreateBACnetApplicationTagCharacterStringBuilder())
	var err error
	b.CharacterStringValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalBitStringValue(bitStringValue BACnetApplicationTagBitString) BACnetNotificationParametersExtendedParametersBuilder {
	b.BitStringValue = bitStringValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalBitStringValueBuilder(builderSupplier func(BACnetApplicationTagBitStringBuilder) BACnetApplicationTagBitStringBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.BitStringValue.CreateBACnetApplicationTagBitStringBuilder())
	var err error
	b.BitStringValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagBitStringBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalEnumeratedValue(enumeratedValue BACnetApplicationTagEnumerated) BACnetNotificationParametersExtendedParametersBuilder {
	b.EnumeratedValue = enumeratedValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalEnumeratedValueBuilder(builderSupplier func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.EnumeratedValue.CreateBACnetApplicationTagEnumeratedBuilder())
	var err error
	b.EnumeratedValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagEnumeratedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalDateValue(dateValue BACnetApplicationTagDate) BACnetNotificationParametersExtendedParametersBuilder {
	b.DateValue = dateValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalDateValueBuilder(builderSupplier func(BACnetApplicationTagDateBuilder) BACnetApplicationTagDateBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.DateValue.CreateBACnetApplicationTagDateBuilder())
	var err error
	b.DateValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagDateBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalTimeValue(timeValue BACnetApplicationTagTime) BACnetNotificationParametersExtendedParametersBuilder {
	b.TimeValue = timeValue
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalTimeValueBuilder(builderSupplier func(BACnetApplicationTagTimeBuilder) BACnetApplicationTagTimeBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.TimeValue.CreateBACnetApplicationTagTimeBuilder())
	var err error
	b.TimeValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalObjectIdentifier(objectIdentifier BACnetApplicationTagObjectIdentifier) BACnetNotificationParametersExtendedParametersBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalObjectIdentifierBuilder(builderSupplier func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetApplicationTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalReference(reference BACnetDeviceObjectPropertyReferenceEnclosed) BACnetNotificationParametersExtendedParametersBuilder {
	b.Reference = reference
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithOptionalReferenceBuilder(builderSupplier func(BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetDeviceObjectPropertyReferenceEnclosedBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.Reference.CreateBACnetDeviceObjectPropertyReferenceEnclosedBuilder())
	var err error
	b.Reference, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDeviceObjectPropertyReferenceEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetNotificationParametersExtendedParametersBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetNotificationParametersExtendedParametersBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) WithArgTagNumber(tagNumber uint8) BACnetNotificationParametersExtendedParametersBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) Build() (BACnetNotificationParametersExtendedParameters, error) {
	if b.OpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'openingTag' not set"))
	}
	if b.PeekedTagHeader == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.ClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'closingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetNotificationParametersExtendedParameters.deepCopy(), nil
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) MustBuild() BACnetNotificationParametersExtendedParameters {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetNotificationParametersExtendedParametersBuilder) DeepCopy() any {
	_copy := b.CreateBACnetNotificationParametersExtendedParametersBuilder().(*_BACnetNotificationParametersExtendedParametersBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetNotificationParametersExtendedParametersBuilder creates a BACnetNotificationParametersExtendedParametersBuilder
func (b *_BACnetNotificationParametersExtendedParameters) CreateBACnetNotificationParametersExtendedParametersBuilder() BACnetNotificationParametersExtendedParametersBuilder {
	if b == nil {
		return NewBACnetNotificationParametersExtendedParametersBuilder()
	}
	return &_BACnetNotificationParametersExtendedParametersBuilder{_BACnetNotificationParametersExtendedParameters: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetNotificationParametersExtendedParameters) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetNotificationParametersExtendedParameters) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

func (m *_BACnetNotificationParametersExtendedParameters) GetNullValue() BACnetApplicationTagNull {
	return m.NullValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetRealValue() BACnetApplicationTagReal {
	return m.RealValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetUnsignedValue() BACnetApplicationTagUnsignedInteger {
	return m.UnsignedValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetBooleanValue() BACnetApplicationTagBoolean {
	return m.BooleanValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetIntegerValue() BACnetApplicationTagSignedInteger {
	return m.IntegerValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetDoubleValue() BACnetApplicationTagDouble {
	return m.DoubleValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetOctetStringValue() BACnetApplicationTagOctetString {
	return m.OctetStringValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetCharacterStringValue() BACnetApplicationTagCharacterString {
	return m.CharacterStringValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetBitStringValue() BACnetApplicationTagBitString {
	return m.BitStringValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetEnumeratedValue() BACnetApplicationTagEnumerated {
	return m.EnumeratedValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetDateValue() BACnetApplicationTagDate {
	return m.DateValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetTimeValue() BACnetApplicationTagTime {
	return m.TimeValue
}

func (m *_BACnetNotificationParametersExtendedParameters) GetObjectIdentifier() BACnetApplicationTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetNotificationParametersExtendedParameters) GetReference() BACnetDeviceObjectPropertyReferenceEnclosed {
	return m.Reference
}

func (m *_BACnetNotificationParametersExtendedParameters) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetNotificationParametersExtendedParameters) GetPeekedTagNumber() uint8 {
	ctx := context.Background()
	_ = ctx
	nullValue := m.GetNullValue()
	_ = nullValue
	realValue := m.GetRealValue()
	_ = realValue
	unsignedValue := m.GetUnsignedValue()
	_ = unsignedValue
	booleanValue := m.GetBooleanValue()
	_ = booleanValue
	integerValue := m.GetIntegerValue()
	_ = integerValue
	doubleValue := m.GetDoubleValue()
	_ = doubleValue
	octetStringValue := m.GetOctetStringValue()
	_ = octetStringValue
	characterStringValue := m.GetCharacterStringValue()
	_ = characterStringValue
	bitStringValue := m.GetBitStringValue()
	_ = bitStringValue
	enumeratedValue := m.GetEnumeratedValue()
	_ = enumeratedValue
	dateValue := m.GetDateValue()
	_ = dateValue
	timeValue := m.GetTimeValue()
	_ = timeValue
	objectIdentifier := m.GetObjectIdentifier()
	_ = objectIdentifier
	reference := m.GetReference()
	_ = reference
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

func (m *_BACnetNotificationParametersExtendedParameters) GetIsOpeningTag() bool {
	ctx := context.Background()
	_ = ctx
	nullValue := m.GetNullValue()
	_ = nullValue
	realValue := m.GetRealValue()
	_ = realValue
	unsignedValue := m.GetUnsignedValue()
	_ = unsignedValue
	booleanValue := m.GetBooleanValue()
	_ = booleanValue
	integerValue := m.GetIntegerValue()
	_ = integerValue
	doubleValue := m.GetDoubleValue()
	_ = doubleValue
	octetStringValue := m.GetOctetStringValue()
	_ = octetStringValue
	characterStringValue := m.GetCharacterStringValue()
	_ = characterStringValue
	bitStringValue := m.GetBitStringValue()
	_ = bitStringValue
	enumeratedValue := m.GetEnumeratedValue()
	_ = enumeratedValue
	dateValue := m.GetDateValue()
	_ = dateValue
	timeValue := m.GetTimeValue()
	_ = timeValue
	objectIdentifier := m.GetObjectIdentifier()
	_ = objectIdentifier
	reference := m.GetReference()
	_ = reference
	return bool(bool((m.GetPeekedTagHeader().GetLengthValueType()) == (0x6)))
}

func (m *_BACnetNotificationParametersExtendedParameters) GetIsClosingTag() bool {
	ctx := context.Background()
	_ = ctx
	nullValue := m.GetNullValue()
	_ = nullValue
	realValue := m.GetRealValue()
	_ = realValue
	unsignedValue := m.GetUnsignedValue()
	_ = unsignedValue
	booleanValue := m.GetBooleanValue()
	_ = booleanValue
	integerValue := m.GetIntegerValue()
	_ = integerValue
	doubleValue := m.GetDoubleValue()
	_ = doubleValue
	octetStringValue := m.GetOctetStringValue()
	_ = octetStringValue
	characterStringValue := m.GetCharacterStringValue()
	_ = characterStringValue
	bitStringValue := m.GetBitStringValue()
	_ = bitStringValue
	enumeratedValue := m.GetEnumeratedValue()
	_ = enumeratedValue
	dateValue := m.GetDateValue()
	_ = dateValue
	timeValue := m.GetTimeValue()
	_ = timeValue
	objectIdentifier := m.GetObjectIdentifier()
	_ = objectIdentifier
	reference := m.GetReference()
	_ = reference
	return bool(bool((m.GetPeekedTagHeader().GetLengthValueType()) == (0x7)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetNotificationParametersExtendedParameters(structType any) BACnetNotificationParametersExtendedParameters {
	if casted, ok := structType.(BACnetNotificationParametersExtendedParameters); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetNotificationParametersExtendedParameters); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetNotificationParametersExtendedParameters) GetTypeName() string {
	return "BACnetNotificationParametersExtendedParameters"
}

func (m *_BACnetNotificationParametersExtendedParameters) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// Optional Field (nullValue)
	if m.NullValue != nil {
		lengthInBits += m.NullValue.GetLengthInBits(ctx)
	}

	// Optional Field (realValue)
	if m.RealValue != nil {
		lengthInBits += m.RealValue.GetLengthInBits(ctx)
	}

	// Optional Field (unsignedValue)
	if m.UnsignedValue != nil {
		lengthInBits += m.UnsignedValue.GetLengthInBits(ctx)
	}

	// Optional Field (booleanValue)
	if m.BooleanValue != nil {
		lengthInBits += m.BooleanValue.GetLengthInBits(ctx)
	}

	// Optional Field (integerValue)
	if m.IntegerValue != nil {
		lengthInBits += m.IntegerValue.GetLengthInBits(ctx)
	}

	// Optional Field (doubleValue)
	if m.DoubleValue != nil {
		lengthInBits += m.DoubleValue.GetLengthInBits(ctx)
	}

	// Optional Field (octetStringValue)
	if m.OctetStringValue != nil {
		lengthInBits += m.OctetStringValue.GetLengthInBits(ctx)
	}

	// Optional Field (characterStringValue)
	if m.CharacterStringValue != nil {
		lengthInBits += m.CharacterStringValue.GetLengthInBits(ctx)
	}

	// Optional Field (bitStringValue)
	if m.BitStringValue != nil {
		lengthInBits += m.BitStringValue.GetLengthInBits(ctx)
	}

	// Optional Field (enumeratedValue)
	if m.EnumeratedValue != nil {
		lengthInBits += m.EnumeratedValue.GetLengthInBits(ctx)
	}

	// Optional Field (dateValue)
	if m.DateValue != nil {
		lengthInBits += m.DateValue.GetLengthInBits(ctx)
	}

	// Optional Field (timeValue)
	if m.TimeValue != nil {
		lengthInBits += m.TimeValue.GetLengthInBits(ctx)
	}

	// Optional Field (objectIdentifier)
	if m.ObjectIdentifier != nil {
		lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)
	}

	// Optional Field (reference)
	if m.Reference != nil {
		lengthInBits += m.Reference.GetLengthInBits(ctx)
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetNotificationParametersExtendedParameters) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetNotificationParametersExtendedParametersParse(ctx context.Context, theBytes []byte, tagNumber uint8) (BACnetNotificationParametersExtendedParameters, error) {
	return BACnetNotificationParametersExtendedParametersParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func BACnetNotificationParametersExtendedParametersParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetNotificationParametersExtendedParameters, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetNotificationParametersExtendedParameters, error) {
		return BACnetNotificationParametersExtendedParametersParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func BACnetNotificationParametersExtendedParametersParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (BACnetNotificationParametersExtendedParameters, error) {
	v, err := (&_BACnetNotificationParametersExtendedParameters{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetNotificationParametersExtendedParameters) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__bACnetNotificationParametersExtendedParameters BACnetNotificationParametersExtendedParameters, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetNotificationParametersExtendedParameters"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetNotificationParametersExtendedParameters")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	isOpeningTag, err := ReadVirtualField[bool](ctx, "isOpeningTag", (*bool)(nil), bool((peekedTagHeader.GetLengthValueType()) == (0x6)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isOpeningTag' field"))
	}
	_ = isOpeningTag

	isClosingTag, err := ReadVirtualField[bool](ctx, "isClosingTag", (*bool)(nil), bool((peekedTagHeader.GetLengthValueType()) == (0x7)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isClosingTag' field"))
	}
	_ = isClosingTag

	var nullValue BACnetApplicationTagNull
	_nullValue, err := ReadOptionalField[BACnetApplicationTagNull](ctx, "nullValue", ReadComplex[BACnetApplicationTagNull](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagNull](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x0))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'nullValue' field"))
	}
	if _nullValue != nil {
		nullValue = *_nullValue
		m.NullValue = nullValue
	}

	var realValue BACnetApplicationTagReal
	_realValue, err := ReadOptionalField[BACnetApplicationTagReal](ctx, "realValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x4))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'realValue' field"))
	}
	if _realValue != nil {
		realValue = *_realValue
		m.RealValue = realValue
	}

	var unsignedValue BACnetApplicationTagUnsignedInteger
	_unsignedValue, err := ReadOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "unsignedValue", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x2))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'unsignedValue' field"))
	}
	if _unsignedValue != nil {
		unsignedValue = *_unsignedValue
		m.UnsignedValue = unsignedValue
	}

	var booleanValue BACnetApplicationTagBoolean
	_booleanValue, err := ReadOptionalField[BACnetApplicationTagBoolean](ctx, "booleanValue", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x1))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'booleanValue' field"))
	}
	if _booleanValue != nil {
		booleanValue = *_booleanValue
		m.BooleanValue = booleanValue
	}

	var integerValue BACnetApplicationTagSignedInteger
	_integerValue, err := ReadOptionalField[BACnetApplicationTagSignedInteger](ctx, "integerValue", ReadComplex[BACnetApplicationTagSignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagSignedInteger](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x3))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'integerValue' field"))
	}
	if _integerValue != nil {
		integerValue = *_integerValue
		m.IntegerValue = integerValue
	}

	var doubleValue BACnetApplicationTagDouble
	_doubleValue, err := ReadOptionalField[BACnetApplicationTagDouble](ctx, "doubleValue", ReadComplex[BACnetApplicationTagDouble](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagDouble](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x5))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'doubleValue' field"))
	}
	if _doubleValue != nil {
		doubleValue = *_doubleValue
		m.DoubleValue = doubleValue
	}

	var octetStringValue BACnetApplicationTagOctetString
	_octetStringValue, err := ReadOptionalField[BACnetApplicationTagOctetString](ctx, "octetStringValue", ReadComplex[BACnetApplicationTagOctetString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagOctetString](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x6))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'octetStringValue' field"))
	}
	if _octetStringValue != nil {
		octetStringValue = *_octetStringValue
		m.OctetStringValue = octetStringValue
	}

	var characterStringValue BACnetApplicationTagCharacterString
	_characterStringValue, err := ReadOptionalField[BACnetApplicationTagCharacterString](ctx, "characterStringValue", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x7))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'characterStringValue' field"))
	}
	if _characterStringValue != nil {
		characterStringValue = *_characterStringValue
		m.CharacterStringValue = characterStringValue
	}

	var bitStringValue BACnetApplicationTagBitString
	_bitStringValue, err := ReadOptionalField[BACnetApplicationTagBitString](ctx, "bitStringValue", ReadComplex[BACnetApplicationTagBitString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBitString](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x8))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bitStringValue' field"))
	}
	if _bitStringValue != nil {
		bitStringValue = *_bitStringValue
		m.BitStringValue = bitStringValue
	}

	var enumeratedValue BACnetApplicationTagEnumerated
	_enumeratedValue, err := ReadOptionalField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", ReadComplex[BACnetApplicationTagEnumerated](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagEnumerated](), readBuffer), bool(bool(bool((peekedTagNumber) == (0x9))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enumeratedValue' field"))
	}
	if _enumeratedValue != nil {
		enumeratedValue = *_enumeratedValue
		m.EnumeratedValue = enumeratedValue
	}

	var dateValue BACnetApplicationTagDate
	_dateValue, err := ReadOptionalField[BACnetApplicationTagDate](ctx, "dateValue", ReadComplex[BACnetApplicationTagDate](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagDate](), readBuffer), bool(bool(bool((peekedTagNumber) == (0xA))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dateValue' field"))
	}
	if _dateValue != nil {
		dateValue = *_dateValue
		m.DateValue = dateValue
	}

	var timeValue BACnetApplicationTagTime
	_timeValue, err := ReadOptionalField[BACnetApplicationTagTime](ctx, "timeValue", ReadComplex[BACnetApplicationTagTime](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagTime](), readBuffer), bool(bool(bool((peekedTagNumber) == (0xB))) && bool(!(isOpeningTag))) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeValue' field"))
	}
	if _timeValue != nil {
		timeValue = *_timeValue
		m.TimeValue = timeValue
	}

	var objectIdentifier BACnetApplicationTagObjectIdentifier
	_objectIdentifier, err := ReadOptionalField[BACnetApplicationTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetApplicationTagObjectIdentifier](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagObjectIdentifier](), readBuffer), bool(bool((peekedTagNumber) == (0xC))) && bool(!(isOpeningTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	if _objectIdentifier != nil {
		objectIdentifier = *_objectIdentifier
		m.ObjectIdentifier = objectIdentifier
	}

	var reference BACnetDeviceObjectPropertyReferenceEnclosed
	_reference, err := ReadOptionalField[BACnetDeviceObjectPropertyReferenceEnclosed](ctx, "reference", ReadComplex[BACnetDeviceObjectPropertyReferenceEnclosed](BACnetDeviceObjectPropertyReferenceEnclosedParseWithBufferProducer((uint8)(uint8(0))), readBuffer), bool(isOpeningTag) && bool(!(isClosingTag)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'reference' field"))
	}
	if _reference != nil {
		reference = *_reference
		m.Reference = reference
	}

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetNotificationParametersExtendedParameters"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetNotificationParametersExtendedParameters")
	}

	return m, nil
}

func (m *_BACnetNotificationParametersExtendedParameters) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetNotificationParametersExtendedParameters) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetNotificationParametersExtendedParameters"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetNotificationParametersExtendedParameters")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}
	// Virtual field
	isOpeningTag := m.GetIsOpeningTag()
	_ = isOpeningTag
	if _isOpeningTagErr := writeBuffer.WriteVirtual(ctx, "isOpeningTag", m.GetIsOpeningTag()); _isOpeningTagErr != nil {
		return errors.Wrap(_isOpeningTagErr, "Error serializing 'isOpeningTag' field")
	}
	// Virtual field
	isClosingTag := m.GetIsClosingTag()
	_ = isClosingTag
	if _isClosingTagErr := writeBuffer.WriteVirtual(ctx, "isClosingTag", m.GetIsClosingTag()); _isClosingTagErr != nil {
		return errors.Wrap(_isClosingTagErr, "Error serializing 'isClosingTag' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagNull](ctx, "nullValue", GetRef(m.GetNullValue()), WriteComplex[BACnetApplicationTagNull](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'nullValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagReal](ctx, "realValue", GetRef(m.GetRealValue()), WriteComplex[BACnetApplicationTagReal](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'realValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "unsignedValue", GetRef(m.GetUnsignedValue()), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'unsignedValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagBoolean](ctx, "booleanValue", GetRef(m.GetBooleanValue()), WriteComplex[BACnetApplicationTagBoolean](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'booleanValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagSignedInteger](ctx, "integerValue", GetRef(m.GetIntegerValue()), WriteComplex[BACnetApplicationTagSignedInteger](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'integerValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagDouble](ctx, "doubleValue", GetRef(m.GetDoubleValue()), WriteComplex[BACnetApplicationTagDouble](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'doubleValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagOctetString](ctx, "octetStringValue", GetRef(m.GetOctetStringValue()), WriteComplex[BACnetApplicationTagOctetString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'octetStringValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagCharacterString](ctx, "characterStringValue", GetRef(m.GetCharacterStringValue()), WriteComplex[BACnetApplicationTagCharacterString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'characterStringValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagBitString](ctx, "bitStringValue", GetRef(m.GetBitStringValue()), WriteComplex[BACnetApplicationTagBitString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'bitStringValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", GetRef(m.GetEnumeratedValue()), WriteComplex[BACnetApplicationTagEnumerated](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'enumeratedValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagDate](ctx, "dateValue", GetRef(m.GetDateValue()), WriteComplex[BACnetApplicationTagDate](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'dateValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagTime](ctx, "timeValue", GetRef(m.GetTimeValue()), WriteComplex[BACnetApplicationTagTime](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'timeValue' field")
	}

	if err := WriteOptionalField[BACnetApplicationTagObjectIdentifier](ctx, "objectIdentifier", GetRef(m.GetObjectIdentifier()), WriteComplex[BACnetApplicationTagObjectIdentifier](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
	}

	if err := WriteOptionalField[BACnetDeviceObjectPropertyReferenceEnclosed](ctx, "reference", GetRef(m.GetReference()), WriteComplex[BACnetDeviceObjectPropertyReferenceEnclosed](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'reference' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetNotificationParametersExtendedParameters"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetNotificationParametersExtendedParameters")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetNotificationParametersExtendedParameters) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_BACnetNotificationParametersExtendedParameters) IsBACnetNotificationParametersExtendedParameters() {
}

func (m *_BACnetNotificationParametersExtendedParameters) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetNotificationParametersExtendedParameters) deepCopy() *_BACnetNotificationParametersExtendedParameters {
	if m == nil {
		return nil
	}
	_BACnetNotificationParametersExtendedParametersCopy := &_BACnetNotificationParametersExtendedParameters{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
		utils.DeepCopy[BACnetApplicationTagNull](m.NullValue),
		utils.DeepCopy[BACnetApplicationTagReal](m.RealValue),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.UnsignedValue),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.BooleanValue),
		utils.DeepCopy[BACnetApplicationTagSignedInteger](m.IntegerValue),
		utils.DeepCopy[BACnetApplicationTagDouble](m.DoubleValue),
		utils.DeepCopy[BACnetApplicationTagOctetString](m.OctetStringValue),
		utils.DeepCopy[BACnetApplicationTagCharacterString](m.CharacterStringValue),
		utils.DeepCopy[BACnetApplicationTagBitString](m.BitStringValue),
		utils.DeepCopy[BACnetApplicationTagEnumerated](m.EnumeratedValue),
		utils.DeepCopy[BACnetApplicationTagDate](m.DateValue),
		utils.DeepCopy[BACnetApplicationTagTime](m.TimeValue),
		utils.DeepCopy[BACnetApplicationTagObjectIdentifier](m.ObjectIdentifier),
		utils.DeepCopy[BACnetDeviceObjectPropertyReferenceEnclosed](m.Reference),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _BACnetNotificationParametersExtendedParametersCopy
}

func (m *_BACnetNotificationParametersExtendedParameters) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
