/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetReadAccessSpecification is the corresponding interface of BACnetReadAccessSpecification
type BACnetReadAccessSpecification interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetContextTagObjectIdentifier
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetListOfPropertyReferences returns ListOfPropertyReferences (property field)
	GetListOfPropertyReferences() []BACnetPropertyReference
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsBACnetReadAccessSpecification is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetReadAccessSpecification()
	// CreateBuilder creates a BACnetReadAccessSpecificationBuilder
	CreateBACnetReadAccessSpecificationBuilder() BACnetReadAccessSpecificationBuilder
}

// _BACnetReadAccessSpecification is the data-structure of this message
type _BACnetReadAccessSpecification struct {
	ObjectIdentifier         BACnetContextTagObjectIdentifier
	OpeningTag               BACnetOpeningTag
	ListOfPropertyReferences []BACnetPropertyReference
	ClosingTag               BACnetClosingTag
}

var _ BACnetReadAccessSpecification = (*_BACnetReadAccessSpecification)(nil)

// NewBACnetReadAccessSpecification factory function for _BACnetReadAccessSpecification
func NewBACnetReadAccessSpecification(objectIdentifier BACnetContextTagObjectIdentifier, openingTag BACnetOpeningTag, listOfPropertyReferences []BACnetPropertyReference, closingTag BACnetClosingTag) *_BACnetReadAccessSpecification {
	if objectIdentifier == nil {
		panic("objectIdentifier of type BACnetContextTagObjectIdentifier for BACnetReadAccessSpecification must not be nil")
	}
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetReadAccessSpecification must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetReadAccessSpecification must not be nil")
	}
	return &_BACnetReadAccessSpecification{ObjectIdentifier: objectIdentifier, OpeningTag: openingTag, ListOfPropertyReferences: listOfPropertyReferences, ClosingTag: closingTag}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetReadAccessSpecificationBuilder is a builder for BACnetReadAccessSpecification
type BACnetReadAccessSpecificationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, openingTag BACnetOpeningTag, listOfPropertyReferences []BACnetPropertyReference, closingTag BACnetClosingTag) BACnetReadAccessSpecificationBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithObjectIdentifier(BACnetContextTagObjectIdentifier) BACnetReadAccessSpecificationBuilder
	// WithObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithObjectIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetReadAccessSpecificationBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetReadAccessSpecificationBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetReadAccessSpecificationBuilder
	// WithListOfPropertyReferences adds ListOfPropertyReferences (property field)
	WithListOfPropertyReferences(...BACnetPropertyReference) BACnetReadAccessSpecificationBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetReadAccessSpecificationBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetReadAccessSpecificationBuilder
	// Build builds the BACnetReadAccessSpecification or returns an error if something is wrong
	Build() (BACnetReadAccessSpecification, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetReadAccessSpecification
}

// NewBACnetReadAccessSpecificationBuilder() creates a BACnetReadAccessSpecificationBuilder
func NewBACnetReadAccessSpecificationBuilder() BACnetReadAccessSpecificationBuilder {
	return &_BACnetReadAccessSpecificationBuilder{_BACnetReadAccessSpecification: new(_BACnetReadAccessSpecification)}
}

type _BACnetReadAccessSpecificationBuilder struct {
	*_BACnetReadAccessSpecification

	collectedErr []error
}

var _ (BACnetReadAccessSpecificationBuilder) = (*_BACnetReadAccessSpecificationBuilder)(nil)

func (b *_BACnetReadAccessSpecificationBuilder) WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier, openingTag BACnetOpeningTag, listOfPropertyReferences []BACnetPropertyReference, closingTag BACnetClosingTag) BACnetReadAccessSpecificationBuilder {
	return b.WithObjectIdentifier(objectIdentifier).WithOpeningTag(openingTag).WithListOfPropertyReferences(listOfPropertyReferences...).WithClosingTag(closingTag)
}

func (b *_BACnetReadAccessSpecificationBuilder) WithObjectIdentifier(objectIdentifier BACnetContextTagObjectIdentifier) BACnetReadAccessSpecificationBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetReadAccessSpecificationBuilder) WithObjectIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetReadAccessSpecificationBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetReadAccessSpecificationBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetReadAccessSpecificationBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetReadAccessSpecificationBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetReadAccessSpecificationBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetReadAccessSpecificationBuilder) WithListOfPropertyReferences(listOfPropertyReferences ...BACnetPropertyReference) BACnetReadAccessSpecificationBuilder {
	b.ListOfPropertyReferences = listOfPropertyReferences
	return b
}

func (b *_BACnetReadAccessSpecificationBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetReadAccessSpecificationBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetReadAccessSpecificationBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetReadAccessSpecificationBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetReadAccessSpecificationBuilder) Build() (BACnetReadAccessSpecification, error) {
	if b.ObjectIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'objectIdentifier' not set"))
	}
	if b.OpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'closingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetReadAccessSpecification.deepCopy(), nil
}

func (b *_BACnetReadAccessSpecificationBuilder) MustBuild() BACnetReadAccessSpecification {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetReadAccessSpecificationBuilder) DeepCopy() any {
	_copy := b.CreateBACnetReadAccessSpecificationBuilder().(*_BACnetReadAccessSpecificationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetReadAccessSpecificationBuilder creates a BACnetReadAccessSpecificationBuilder
func (b *_BACnetReadAccessSpecification) CreateBACnetReadAccessSpecificationBuilder() BACnetReadAccessSpecificationBuilder {
	if b == nil {
		return NewBACnetReadAccessSpecificationBuilder()
	}
	return &_BACnetReadAccessSpecificationBuilder{_BACnetReadAccessSpecification: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetReadAccessSpecification) GetObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetReadAccessSpecification) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetReadAccessSpecification) GetListOfPropertyReferences() []BACnetPropertyReference {
	return m.ListOfPropertyReferences
}

func (m *_BACnetReadAccessSpecification) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetReadAccessSpecification(structType any) BACnetReadAccessSpecification {
	if casted, ok := structType.(BACnetReadAccessSpecification); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetReadAccessSpecification); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetReadAccessSpecification) GetTypeName() string {
	return "BACnetReadAccessSpecification"
}

func (m *_BACnetReadAccessSpecification) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (objectIdentifier)
	lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.ListOfPropertyReferences) > 0 {
		for _, element := range m.ListOfPropertyReferences {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetReadAccessSpecification) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetReadAccessSpecificationParse(ctx context.Context, theBytes []byte) (BACnetReadAccessSpecification, error) {
	return BACnetReadAccessSpecificationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetReadAccessSpecificationParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReadAccessSpecification, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReadAccessSpecification, error) {
		return BACnetReadAccessSpecificationParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetReadAccessSpecificationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReadAccessSpecification, error) {
	v, err := (&_BACnetReadAccessSpecification{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetReadAccessSpecification) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetReadAccessSpecification BACnetReadAccessSpecification, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetReadAccessSpecification"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetReadAccessSpecification")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	m.ObjectIdentifier = objectIdentifier

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(uint8(1))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	listOfPropertyReferences, err := ReadTerminatedArrayField[BACnetPropertyReference](ctx, "listOfPropertyReferences", ReadComplex[BACnetPropertyReference](BACnetPropertyReferenceParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, 1))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfPropertyReferences' field"))
	}
	m.ListOfPropertyReferences = listOfPropertyReferences

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(uint8(1))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetReadAccessSpecification"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetReadAccessSpecification")
	}

	return m, nil
}

func (m *_BACnetReadAccessSpecification) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetReadAccessSpecification) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetReadAccessSpecification"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetReadAccessSpecification")
	}

	if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", m.GetObjectIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "listOfPropertyReferences", m.GetListOfPropertyReferences(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'listOfPropertyReferences' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetReadAccessSpecification"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetReadAccessSpecification")
	}
	return nil
}

func (m *_BACnetReadAccessSpecification) IsBACnetReadAccessSpecification() {}

func (m *_BACnetReadAccessSpecification) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetReadAccessSpecification) deepCopy() *_BACnetReadAccessSpecification {
	if m == nil {
		return nil
	}
	_BACnetReadAccessSpecificationCopy := &_BACnetReadAccessSpecification{
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.ObjectIdentifier),
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopySlice[BACnetPropertyReference, BACnetPropertyReference](m.ListOfPropertyReferences),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
	}
	return _BACnetReadAccessSpecificationCopy
}

func (m *_BACnetReadAccessSpecification) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
