/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NotificationMessage is the corresponding interface of NotificationMessage
type NotificationMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSequenceNumber returns SequenceNumber (property field)
	GetSequenceNumber() uint32
	// GetPublishTime returns PublishTime (property field)
	GetPublishTime() int64
	// GetNotificationData returns NotificationData (property field)
	GetNotificationData() []ExtensionObject
	// IsNotificationMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNotificationMessage()
	// CreateBuilder creates a NotificationMessageBuilder
	CreateNotificationMessageBuilder() NotificationMessageBuilder
}

// _NotificationMessage is the data-structure of this message
type _NotificationMessage struct {
	ExtensionObjectDefinitionContract
	SequenceNumber   uint32
	PublishTime      int64
	NotificationData []ExtensionObject
}

var _ NotificationMessage = (*_NotificationMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_NotificationMessage)(nil)

// NewNotificationMessage factory function for _NotificationMessage
func NewNotificationMessage(sequenceNumber uint32, publishTime int64, notificationData []ExtensionObject) *_NotificationMessage {
	_result := &_NotificationMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		SequenceNumber:                    sequenceNumber,
		PublishTime:                       publishTime,
		NotificationData:                  notificationData,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NotificationMessageBuilder is a builder for NotificationMessage
type NotificationMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(sequenceNumber uint32, publishTime int64, notificationData []ExtensionObject) NotificationMessageBuilder
	// WithSequenceNumber adds SequenceNumber (property field)
	WithSequenceNumber(uint32) NotificationMessageBuilder
	// WithPublishTime adds PublishTime (property field)
	WithPublishTime(int64) NotificationMessageBuilder
	// WithNotificationData adds NotificationData (property field)
	WithNotificationData(...ExtensionObject) NotificationMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the NotificationMessage or returns an error if something is wrong
	Build() (NotificationMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NotificationMessage
}

// NewNotificationMessageBuilder() creates a NotificationMessageBuilder
func NewNotificationMessageBuilder() NotificationMessageBuilder {
	return &_NotificationMessageBuilder{_NotificationMessage: new(_NotificationMessage)}
}

type _NotificationMessageBuilder struct {
	*_NotificationMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (NotificationMessageBuilder) = (*_NotificationMessageBuilder)(nil)

func (b *_NotificationMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._NotificationMessage
}

func (b *_NotificationMessageBuilder) WithMandatoryFields(sequenceNumber uint32, publishTime int64, notificationData []ExtensionObject) NotificationMessageBuilder {
	return b.WithSequenceNumber(sequenceNumber).WithPublishTime(publishTime).WithNotificationData(notificationData...)
}

func (b *_NotificationMessageBuilder) WithSequenceNumber(sequenceNumber uint32) NotificationMessageBuilder {
	b.SequenceNumber = sequenceNumber
	return b
}

func (b *_NotificationMessageBuilder) WithPublishTime(publishTime int64) NotificationMessageBuilder {
	b.PublishTime = publishTime
	return b
}

func (b *_NotificationMessageBuilder) WithNotificationData(notificationData ...ExtensionObject) NotificationMessageBuilder {
	b.NotificationData = notificationData
	return b
}

func (b *_NotificationMessageBuilder) Build() (NotificationMessage, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._NotificationMessage.deepCopy(), nil
}

func (b *_NotificationMessageBuilder) MustBuild() NotificationMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NotificationMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_NotificationMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_NotificationMessageBuilder) DeepCopy() any {
	_copy := b.CreateNotificationMessageBuilder().(*_NotificationMessageBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateNotificationMessageBuilder creates a NotificationMessageBuilder
func (b *_NotificationMessage) CreateNotificationMessageBuilder() NotificationMessageBuilder {
	if b == nil {
		return NewNotificationMessageBuilder()
	}
	return &_NotificationMessageBuilder{_NotificationMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NotificationMessage) GetExtensionId() int32 {
	return int32(805)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NotificationMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NotificationMessage) GetSequenceNumber() uint32 {
	return m.SequenceNumber
}

func (m *_NotificationMessage) GetPublishTime() int64 {
	return m.PublishTime
}

func (m *_NotificationMessage) GetNotificationData() []ExtensionObject {
	return m.NotificationData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNotificationMessage(structType any) NotificationMessage {
	if casted, ok := structType.(NotificationMessage); ok {
		return casted
	}
	if casted, ok := structType.(*NotificationMessage); ok {
		return *casted
	}
	return nil
}

func (m *_NotificationMessage) GetTypeName() string {
	return "NotificationMessage"
}

func (m *_NotificationMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (sequenceNumber)
	lengthInBits += 32

	// Simple field (publishTime)
	lengthInBits += 64

	// Implicit Field (noOfNotificationData)
	lengthInBits += 32

	// Array field
	if len(m.NotificationData) > 0 {
		for _curItem, element := range m.NotificationData {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.NotificationData), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_NotificationMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NotificationMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__notificationMessage NotificationMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NotificationMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NotificationMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	sequenceNumber, err := ReadSimpleField(ctx, "sequenceNumber", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sequenceNumber' field"))
	}
	m.SequenceNumber = sequenceNumber

	publishTime, err := ReadSimpleField(ctx, "publishTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publishTime' field"))
	}
	m.PublishTime = publishTime

	noOfNotificationData, err := ReadImplicitField[int32](ctx, "noOfNotificationData", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfNotificationData' field"))
	}
	_ = noOfNotificationData

	notificationData, err := ReadCountArrayField[ExtensionObject](ctx, "notificationData", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer), uint64(noOfNotificationData))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notificationData' field"))
	}
	m.NotificationData = notificationData

	if closeErr := readBuffer.CloseContext("NotificationMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NotificationMessage")
	}

	return m, nil
}

func (m *_NotificationMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NotificationMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NotificationMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NotificationMessage")
		}

		if err := WriteSimpleField[uint32](ctx, "sequenceNumber", m.GetSequenceNumber(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'sequenceNumber' field")
		}

		if err := WriteSimpleField[int64](ctx, "publishTime", m.GetPublishTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'publishTime' field")
		}
		noOfNotificationData := int32(utils.InlineIf(bool((m.GetNotificationData()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetNotificationData()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfNotificationData", noOfNotificationData, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfNotificationData' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "notificationData", m.GetNotificationData(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'notificationData' field")
		}

		if popErr := writeBuffer.PopContext("NotificationMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NotificationMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NotificationMessage) IsNotificationMessage() {}

func (m *_NotificationMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NotificationMessage) deepCopy() *_NotificationMessage {
	if m == nil {
		return nil
	}
	_NotificationMessageCopy := &_NotificationMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.SequenceNumber,
		m.PublishTime,
		utils.DeepCopySlice[ExtensionObject, ExtensionObject](m.NotificationData),
	}
	_NotificationMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _NotificationMessageCopy
}

func (m *_NotificationMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
