/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariableAttributes is the corresponding interface of VariableAttributes
type VariableAttributes interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSpecifiedAttributes returns SpecifiedAttributes (property field)
	GetSpecifiedAttributes() uint32
	// GetDisplayName returns DisplayName (property field)
	GetDisplayName() LocalizedText
	// GetDescription returns Description (property field)
	GetDescription() LocalizedText
	// GetWriteMask returns WriteMask (property field)
	GetWriteMask() uint32
	// GetUserWriteMask returns UserWriteMask (property field)
	GetUserWriteMask() uint32
	// GetValue returns Value (property field)
	GetValue() Variant
	// GetDataType returns DataType (property field)
	GetDataType() NodeId
	// GetValueRank returns ValueRank (property field)
	GetValueRank() int32
	// GetArrayDimensions returns ArrayDimensions (property field)
	GetArrayDimensions() []uint32
	// GetAccessLevel returns AccessLevel (property field)
	GetAccessLevel() uint8
	// GetUserAccessLevel returns UserAccessLevel (property field)
	GetUserAccessLevel() uint8
	// GetMinimumSamplingInterval returns MinimumSamplingInterval (property field)
	GetMinimumSamplingInterval() float64
	// GetHistorizing returns Historizing (property field)
	GetHistorizing() bool
	// IsVariableAttributes is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariableAttributes()
	// CreateBuilder creates a VariableAttributesBuilder
	CreateVariableAttributesBuilder() VariableAttributesBuilder
}

// _VariableAttributes is the data-structure of this message
type _VariableAttributes struct {
	ExtensionObjectDefinitionContract
	SpecifiedAttributes     uint32
	DisplayName             LocalizedText
	Description             LocalizedText
	WriteMask               uint32
	UserWriteMask           uint32
	Value                   Variant
	DataType                NodeId
	ValueRank               int32
	ArrayDimensions         []uint32
	AccessLevel             uint8
	UserAccessLevel         uint8
	MinimumSamplingInterval float64
	Historizing             bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ VariableAttributes = (*_VariableAttributes)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_VariableAttributes)(nil)

// NewVariableAttributes factory function for _VariableAttributes
func NewVariableAttributes(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, value Variant, dataType NodeId, valueRank int32, arrayDimensions []uint32, accessLevel uint8, userAccessLevel uint8, minimumSamplingInterval float64, historizing bool) *_VariableAttributes {
	if displayName == nil {
		panic("displayName of type LocalizedText for VariableAttributes must not be nil")
	}
	if description == nil {
		panic("description of type LocalizedText for VariableAttributes must not be nil")
	}
	if value == nil {
		panic("value of type Variant for VariableAttributes must not be nil")
	}
	if dataType == nil {
		panic("dataType of type NodeId for VariableAttributes must not be nil")
	}
	_result := &_VariableAttributes{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		SpecifiedAttributes:               specifiedAttributes,
		DisplayName:                       displayName,
		Description:                       description,
		WriteMask:                         writeMask,
		UserWriteMask:                     userWriteMask,
		Value:                             value,
		DataType:                          dataType,
		ValueRank:                         valueRank,
		ArrayDimensions:                   arrayDimensions,
		AccessLevel:                       accessLevel,
		UserAccessLevel:                   userAccessLevel,
		MinimumSamplingInterval:           minimumSamplingInterval,
		Historizing:                       historizing,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariableAttributesBuilder is a builder for VariableAttributes
type VariableAttributesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, value Variant, dataType NodeId, valueRank int32, arrayDimensions []uint32, accessLevel uint8, userAccessLevel uint8, minimumSamplingInterval float64, historizing bool) VariableAttributesBuilder
	// WithSpecifiedAttributes adds SpecifiedAttributes (property field)
	WithSpecifiedAttributes(uint32) VariableAttributesBuilder
	// WithDisplayName adds DisplayName (property field)
	WithDisplayName(LocalizedText) VariableAttributesBuilder
	// WithDisplayNameBuilder adds DisplayName (property field) which is build by the builder
	WithDisplayNameBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) VariableAttributesBuilder
	// WithDescription adds Description (property field)
	WithDescription(LocalizedText) VariableAttributesBuilder
	// WithDescriptionBuilder adds Description (property field) which is build by the builder
	WithDescriptionBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) VariableAttributesBuilder
	// WithWriteMask adds WriteMask (property field)
	WithWriteMask(uint32) VariableAttributesBuilder
	// WithUserWriteMask adds UserWriteMask (property field)
	WithUserWriteMask(uint32) VariableAttributesBuilder
	// WithValue adds Value (property field)
	WithValue(Variant) VariableAttributesBuilder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(VariantBuilder) VariantBuilder) VariableAttributesBuilder
	// WithDataType adds DataType (property field)
	WithDataType(NodeId) VariableAttributesBuilder
	// WithDataTypeBuilder adds DataType (property field) which is build by the builder
	WithDataTypeBuilder(func(NodeIdBuilder) NodeIdBuilder) VariableAttributesBuilder
	// WithValueRank adds ValueRank (property field)
	WithValueRank(int32) VariableAttributesBuilder
	// WithArrayDimensions adds ArrayDimensions (property field)
	WithArrayDimensions(...uint32) VariableAttributesBuilder
	// WithAccessLevel adds AccessLevel (property field)
	WithAccessLevel(uint8) VariableAttributesBuilder
	// WithUserAccessLevel adds UserAccessLevel (property field)
	WithUserAccessLevel(uint8) VariableAttributesBuilder
	// WithMinimumSamplingInterval adds MinimumSamplingInterval (property field)
	WithMinimumSamplingInterval(float64) VariableAttributesBuilder
	// WithHistorizing adds Historizing (property field)
	WithHistorizing(bool) VariableAttributesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the VariableAttributes or returns an error if something is wrong
	Build() (VariableAttributes, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariableAttributes
}

// NewVariableAttributesBuilder() creates a VariableAttributesBuilder
func NewVariableAttributesBuilder() VariableAttributesBuilder {
	return &_VariableAttributesBuilder{_VariableAttributes: new(_VariableAttributes)}
}

type _VariableAttributesBuilder struct {
	*_VariableAttributes

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (VariableAttributesBuilder) = (*_VariableAttributesBuilder)(nil)

func (b *_VariableAttributesBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._VariableAttributes
}

func (b *_VariableAttributesBuilder) WithMandatoryFields(specifiedAttributes uint32, displayName LocalizedText, description LocalizedText, writeMask uint32, userWriteMask uint32, value Variant, dataType NodeId, valueRank int32, arrayDimensions []uint32, accessLevel uint8, userAccessLevel uint8, minimumSamplingInterval float64, historizing bool) VariableAttributesBuilder {
	return b.WithSpecifiedAttributes(specifiedAttributes).WithDisplayName(displayName).WithDescription(description).WithWriteMask(writeMask).WithUserWriteMask(userWriteMask).WithValue(value).WithDataType(dataType).WithValueRank(valueRank).WithArrayDimensions(arrayDimensions...).WithAccessLevel(accessLevel).WithUserAccessLevel(userAccessLevel).WithMinimumSamplingInterval(minimumSamplingInterval).WithHistorizing(historizing)
}

func (b *_VariableAttributesBuilder) WithSpecifiedAttributes(specifiedAttributes uint32) VariableAttributesBuilder {
	b.SpecifiedAttributes = specifiedAttributes
	return b
}

func (b *_VariableAttributesBuilder) WithDisplayName(displayName LocalizedText) VariableAttributesBuilder {
	b.DisplayName = displayName
	return b
}

func (b *_VariableAttributesBuilder) WithDisplayNameBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) VariableAttributesBuilder {
	builder := builderSupplier(b.DisplayName.CreateLocalizedTextBuilder())
	var err error
	b.DisplayName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_VariableAttributesBuilder) WithDescription(description LocalizedText) VariableAttributesBuilder {
	b.Description = description
	return b
}

func (b *_VariableAttributesBuilder) WithDescriptionBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) VariableAttributesBuilder {
	builder := builderSupplier(b.Description.CreateLocalizedTextBuilder())
	var err error
	b.Description, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_VariableAttributesBuilder) WithWriteMask(writeMask uint32) VariableAttributesBuilder {
	b.WriteMask = writeMask
	return b
}

func (b *_VariableAttributesBuilder) WithUserWriteMask(userWriteMask uint32) VariableAttributesBuilder {
	b.UserWriteMask = userWriteMask
	return b
}

func (b *_VariableAttributesBuilder) WithValue(value Variant) VariableAttributesBuilder {
	b.Value = value
	return b
}

func (b *_VariableAttributesBuilder) WithValueBuilder(builderSupplier func(VariantBuilder) VariantBuilder) VariableAttributesBuilder {
	builder := builderSupplier(b.Value.CreateVariantBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_VariableAttributesBuilder) WithDataType(dataType NodeId) VariableAttributesBuilder {
	b.DataType = dataType
	return b
}

func (b *_VariableAttributesBuilder) WithDataTypeBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) VariableAttributesBuilder {
	builder := builderSupplier(b.DataType.CreateNodeIdBuilder())
	var err error
	b.DataType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_VariableAttributesBuilder) WithValueRank(valueRank int32) VariableAttributesBuilder {
	b.ValueRank = valueRank
	return b
}

func (b *_VariableAttributesBuilder) WithArrayDimensions(arrayDimensions ...uint32) VariableAttributesBuilder {
	b.ArrayDimensions = arrayDimensions
	return b
}

func (b *_VariableAttributesBuilder) WithAccessLevel(accessLevel uint8) VariableAttributesBuilder {
	b.AccessLevel = accessLevel
	return b
}

func (b *_VariableAttributesBuilder) WithUserAccessLevel(userAccessLevel uint8) VariableAttributesBuilder {
	b.UserAccessLevel = userAccessLevel
	return b
}

func (b *_VariableAttributesBuilder) WithMinimumSamplingInterval(minimumSamplingInterval float64) VariableAttributesBuilder {
	b.MinimumSamplingInterval = minimumSamplingInterval
	return b
}

func (b *_VariableAttributesBuilder) WithHistorizing(historizing bool) VariableAttributesBuilder {
	b.Historizing = historizing
	return b
}

func (b *_VariableAttributesBuilder) Build() (VariableAttributes, error) {
	if b.DisplayName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'displayName' not set"))
	}
	if b.Description == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'description' not set"))
	}
	if b.Value == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'value' not set"))
	}
	if b.DataType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'dataType' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._VariableAttributes.deepCopy(), nil
}

func (b *_VariableAttributesBuilder) MustBuild() VariableAttributes {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariableAttributesBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_VariableAttributesBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_VariableAttributesBuilder) DeepCopy() any {
	_copy := b.CreateVariableAttributesBuilder().(*_VariableAttributesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateVariableAttributesBuilder creates a VariableAttributesBuilder
func (b *_VariableAttributes) CreateVariableAttributesBuilder() VariableAttributesBuilder {
	if b == nil {
		return NewVariableAttributesBuilder()
	}
	return &_VariableAttributesBuilder{_VariableAttributes: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariableAttributes) GetExtensionId() int32 {
	return int32(357)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariableAttributes) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariableAttributes) GetSpecifiedAttributes() uint32 {
	return m.SpecifiedAttributes
}

func (m *_VariableAttributes) GetDisplayName() LocalizedText {
	return m.DisplayName
}

func (m *_VariableAttributes) GetDescription() LocalizedText {
	return m.Description
}

func (m *_VariableAttributes) GetWriteMask() uint32 {
	return m.WriteMask
}

func (m *_VariableAttributes) GetUserWriteMask() uint32 {
	return m.UserWriteMask
}

func (m *_VariableAttributes) GetValue() Variant {
	return m.Value
}

func (m *_VariableAttributes) GetDataType() NodeId {
	return m.DataType
}

func (m *_VariableAttributes) GetValueRank() int32 {
	return m.ValueRank
}

func (m *_VariableAttributes) GetArrayDimensions() []uint32 {
	return m.ArrayDimensions
}

func (m *_VariableAttributes) GetAccessLevel() uint8 {
	return m.AccessLevel
}

func (m *_VariableAttributes) GetUserAccessLevel() uint8 {
	return m.UserAccessLevel
}

func (m *_VariableAttributes) GetMinimumSamplingInterval() float64 {
	return m.MinimumSamplingInterval
}

func (m *_VariableAttributes) GetHistorizing() bool {
	return m.Historizing
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariableAttributes(structType any) VariableAttributes {
	if casted, ok := structType.(VariableAttributes); ok {
		return casted
	}
	if casted, ok := structType.(*VariableAttributes); ok {
		return *casted
	}
	return nil
}

func (m *_VariableAttributes) GetTypeName() string {
	return "VariableAttributes"
}

func (m *_VariableAttributes) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (specifiedAttributes)
	lengthInBits += 32

	// Simple field (displayName)
	lengthInBits += m.DisplayName.GetLengthInBits(ctx)

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	// Simple field (writeMask)
	lengthInBits += 32

	// Simple field (userWriteMask)
	lengthInBits += 32

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	// Simple field (dataType)
	lengthInBits += m.DataType.GetLengthInBits(ctx)

	// Simple field (valueRank)
	lengthInBits += 32

	// Implicit Field (noOfArrayDimensions)
	lengthInBits += 32

	// Array field
	if len(m.ArrayDimensions) > 0 {
		lengthInBits += 32 * uint16(len(m.ArrayDimensions))
	}

	// Simple field (accessLevel)
	lengthInBits += 8

	// Simple field (userAccessLevel)
	lengthInBits += 8

	// Simple field (minimumSamplingInterval)
	lengthInBits += 64

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (historizing)
	lengthInBits += 1

	return lengthInBits
}

func (m *_VariableAttributes) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariableAttributes) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__variableAttributes VariableAttributes, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariableAttributes"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariableAttributes")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	specifiedAttributes, err := ReadSimpleField(ctx, "specifiedAttributes", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'specifiedAttributes' field"))
	}
	m.SpecifiedAttributes = specifiedAttributes

	displayName, err := ReadSimpleField[LocalizedText](ctx, "displayName", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'displayName' field"))
	}
	m.DisplayName = displayName

	description, err := ReadSimpleField[LocalizedText](ctx, "description", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'description' field"))
	}
	m.Description = description

	writeMask, err := ReadSimpleField(ctx, "writeMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeMask' field"))
	}
	m.WriteMask = writeMask

	userWriteMask, err := ReadSimpleField(ctx, "userWriteMask", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userWriteMask' field"))
	}
	m.UserWriteMask = userWriteMask

	value, err := ReadSimpleField[Variant](ctx, "value", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	dataType, err := ReadSimpleField[NodeId](ctx, "dataType", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataType' field"))
	}
	m.DataType = dataType

	valueRank, err := ReadSimpleField(ctx, "valueRank", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'valueRank' field"))
	}
	m.ValueRank = valueRank

	noOfArrayDimensions, err := ReadImplicitField[int32](ctx, "noOfArrayDimensions", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfArrayDimensions' field"))
	}
	_ = noOfArrayDimensions

	arrayDimensions, err := ReadCountArrayField[uint32](ctx, "arrayDimensions", ReadUnsignedInt(readBuffer, uint8(32)), uint64(noOfArrayDimensions))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayDimensions' field"))
	}
	m.ArrayDimensions = arrayDimensions

	accessLevel, err := ReadSimpleField(ctx, "accessLevel", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessLevel' field"))
	}
	m.AccessLevel = accessLevel

	userAccessLevel, err := ReadSimpleField(ctx, "userAccessLevel", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userAccessLevel' field"))
	}
	m.UserAccessLevel = userAccessLevel

	minimumSamplingInterval, err := ReadSimpleField(ctx, "minimumSamplingInterval", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'minimumSamplingInterval' field"))
	}
	m.MinimumSamplingInterval = minimumSamplingInterval

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	historizing, err := ReadSimpleField(ctx, "historizing", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'historizing' field"))
	}
	m.Historizing = historizing

	if closeErr := readBuffer.CloseContext("VariableAttributes"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariableAttributes")
	}

	return m, nil
}

func (m *_VariableAttributes) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariableAttributes) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariableAttributes"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariableAttributes")
		}

		if err := WriteSimpleField[uint32](ctx, "specifiedAttributes", m.GetSpecifiedAttributes(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'specifiedAttributes' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "displayName", m.GetDisplayName(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'displayName' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "description", m.GetDescription(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'description' field")
		}

		if err := WriteSimpleField[uint32](ctx, "writeMask", m.GetWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'writeMask' field")
		}

		if err := WriteSimpleField[uint32](ctx, "userWriteMask", m.GetUserWriteMask(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'userWriteMask' field")
		}

		if err := WriteSimpleField[Variant](ctx, "value", m.GetValue(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if err := WriteSimpleField[NodeId](ctx, "dataType", m.GetDataType(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataType' field")
		}

		if err := WriteSimpleField[int32](ctx, "valueRank", m.GetValueRank(), WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'valueRank' field")
		}
		noOfArrayDimensions := int32(utils.InlineIf(bool((m.GetArrayDimensions()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetArrayDimensions()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfArrayDimensions", noOfArrayDimensions, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfArrayDimensions' field")
		}

		if err := WriteSimpleTypeArrayField(ctx, "arrayDimensions", m.GetArrayDimensions(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayDimensions' field")
		}

		if err := WriteSimpleField[uint8](ctx, "accessLevel", m.GetAccessLevel(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessLevel' field")
		}

		if err := WriteSimpleField[uint8](ctx, "userAccessLevel", m.GetUserAccessLevel(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'userAccessLevel' field")
		}

		if err := WriteSimpleField[float64](ctx, "minimumSamplingInterval", m.GetMinimumSamplingInterval(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'minimumSamplingInterval' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "historizing", m.GetHistorizing(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'historizing' field")
		}

		if popErr := writeBuffer.PopContext("VariableAttributes"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariableAttributes")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariableAttributes) IsVariableAttributes() {}

func (m *_VariableAttributes) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariableAttributes) deepCopy() *_VariableAttributes {
	if m == nil {
		return nil
	}
	_VariableAttributesCopy := &_VariableAttributes{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.SpecifiedAttributes,
		utils.DeepCopy[LocalizedText](m.DisplayName),
		utils.DeepCopy[LocalizedText](m.Description),
		m.WriteMask,
		m.UserWriteMask,
		utils.DeepCopy[Variant](m.Value),
		utils.DeepCopy[NodeId](m.DataType),
		m.ValueRank,
		utils.DeepCopySlice[uint32, uint32](m.ArrayDimensions),
		m.AccessLevel,
		m.UserAccessLevel,
		m.MinimumSamplingInterval,
		m.Historizing,
		m.reservedField0,
	}
	_VariableAttributesCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _VariableAttributesCopy
}

func (m *_VariableAttributes) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
