/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ApplicationIdentityDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15558;
  }

  // Properties.
  protected final PascalString name;
  protected final List<KeyValuePair> recordProperties;
  protected final PascalString applicationUri;
  protected final List<LocalizedText> applicationNames;
  protected final List<ApplicationDescription> additionalServers;

  public ApplicationIdentityDataType(
      PascalString name,
      List<KeyValuePair> recordProperties,
      PascalString applicationUri,
      List<LocalizedText> applicationNames,
      List<ApplicationDescription> additionalServers) {
    super();
    this.name = name;
    this.recordProperties = recordProperties;
    this.applicationUri = applicationUri;
    this.applicationNames = applicationNames;
    this.additionalServers = additionalServers;
  }

  public PascalString getName() {
    return name;
  }

  public List<KeyValuePair> getRecordProperties() {
    return recordProperties;
  }

  public PascalString getApplicationUri() {
    return applicationUri;
  }

  public List<LocalizedText> getApplicationNames() {
    return applicationNames;
  }

  public List<ApplicationDescription> getAdditionalServers() {
    return additionalServers;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ApplicationIdentityDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Implicit Field (noOfRecordProperties) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfRecordProperties =
        (int) ((((getRecordProperties()) == (null)) ? -(1) : COUNT(getRecordProperties())));
    writeImplicitField(
        "noOfRecordProperties", noOfRecordProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (recordProperties)
    writeComplexTypeArrayField("recordProperties", recordProperties, writeBuffer);

    // Simple Field (applicationUri)
    writeSimpleField("applicationUri", applicationUri, writeComplex(writeBuffer));

    // Implicit Field (noOfApplicationNames) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfApplicationNames =
        (int) ((((getApplicationNames()) == (null)) ? -(1) : COUNT(getApplicationNames())));
    writeImplicitField(
        "noOfApplicationNames", noOfApplicationNames, writeSignedInt(writeBuffer, 32));

    // Array Field (applicationNames)
    writeComplexTypeArrayField("applicationNames", applicationNames, writeBuffer);

    // Implicit Field (noOfAdditionalServers) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfAdditionalServers =
        (int) ((((getAdditionalServers()) == (null)) ? -(1) : COUNT(getAdditionalServers())));
    writeImplicitField(
        "noOfAdditionalServers", noOfAdditionalServers, writeSignedInt(writeBuffer, 32));

    // Array Field (additionalServers)
    writeComplexTypeArrayField("additionalServers", additionalServers, writeBuffer);

    writeBuffer.popContext("ApplicationIdentityDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ApplicationIdentityDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Implicit Field (noOfRecordProperties)
    lengthInBits += 32;

    // Array field
    if (recordProperties != null) {
      int i = 0;
      for (KeyValuePair element : recordProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= recordProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (applicationUri)
    lengthInBits += applicationUri.getLengthInBits();

    // Implicit Field (noOfApplicationNames)
    lengthInBits += 32;

    // Array field
    if (applicationNames != null) {
      int i = 0;
      for (LocalizedText element : applicationNames) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= applicationNames.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfAdditionalServers)
    lengthInBits += 32;

    // Array field
    if (additionalServers != null) {
      int i = 0;
      for (ApplicationDescription element : additionalServers) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= additionalServers.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ApplicationIdentityDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfRecordProperties =
        readImplicitField("noOfRecordProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> recordProperties =
        readCountArrayField(
            "recordProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfRecordProperties);

    PascalString applicationUri =
        readSimpleField(
            "applicationUri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfApplicationNames =
        readImplicitField("noOfApplicationNames", readSignedInt(readBuffer, 32));

    List<LocalizedText> applicationNames =
        readCountArrayField(
            "applicationNames",
            readComplex(() -> LocalizedText.staticParse(readBuffer), readBuffer),
            noOfApplicationNames);

    int noOfAdditionalServers =
        readImplicitField("noOfAdditionalServers", readSignedInt(readBuffer, 32));

    List<ApplicationDescription> additionalServers =
        readCountArrayField(
            "additionalServers",
            readComplex(
                () ->
                    (ApplicationDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (310)),
                readBuffer),
            noOfAdditionalServers);

    readBuffer.closeContext("ApplicationIdentityDataType");
    // Create the instance
    return new ApplicationIdentityDataTypeBuilderImpl(
        name, recordProperties, applicationUri, applicationNames, additionalServers);
  }

  public static class ApplicationIdentityDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final List<KeyValuePair> recordProperties;
    private final PascalString applicationUri;
    private final List<LocalizedText> applicationNames;
    private final List<ApplicationDescription> additionalServers;

    public ApplicationIdentityDataTypeBuilderImpl(
        PascalString name,
        List<KeyValuePair> recordProperties,
        PascalString applicationUri,
        List<LocalizedText> applicationNames,
        List<ApplicationDescription> additionalServers) {
      this.name = name;
      this.recordProperties = recordProperties;
      this.applicationUri = applicationUri;
      this.applicationNames = applicationNames;
      this.additionalServers = additionalServers;
    }

    public ApplicationIdentityDataType build() {
      ApplicationIdentityDataType applicationIdentityDataType =
          new ApplicationIdentityDataType(
              name, recordProperties, applicationUri, applicationNames, additionalServers);
      return applicationIdentityDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ApplicationIdentityDataType)) {
      return false;
    }
    ApplicationIdentityDataType that = (ApplicationIdentityDataType) o;
    return (getName() == that.getName())
        && (getRecordProperties() == that.getRecordProperties())
        && (getApplicationUri() == that.getApplicationUri())
        && (getApplicationNames() == that.getApplicationNames())
        && (getAdditionalServers() == that.getAdditionalServers())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getRecordProperties(),
        getApplicationUri(),
        getApplicationNames(),
        getAdditionalServers());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
