/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_RealIdentificationApi implements Message {

  // Constant values.
  public static final Long API = 0x00000000L;

  // Properties.
  protected final List<PnIoCm_RealIdentificationApi_Slot> slots;

  public PnIoCm_RealIdentificationApi(List<PnIoCm_RealIdentificationApi_Slot> slots) {
    super();
    this.slots = slots;
  }

  public List<PnIoCm_RealIdentificationApi_Slot> getSlots() {
    return slots;
  }

  public long getApi() {
    return API;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_RealIdentificationApi");

    // Const Field (api)
    writeConstField(
        "api",
        API,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Implicit Field (numSlots) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    int numSlots = (int) (COUNT(getSlots()));
    writeImplicitField(
        "numSlots",
        numSlots,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Array Field (slots)
    writeComplexTypeArrayField(
        "slots", slots, writeBuffer, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_RealIdentificationApi");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PnIoCm_RealIdentificationApi _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (api)
    lengthInBits += 32;

    // Implicit Field (numSlots)
    lengthInBits += 16;

    // Array field
    if (slots != null) {
      int i = 0;
      for (PnIoCm_RealIdentificationApi_Slot element : slots) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= slots.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static PnIoCm_RealIdentificationApi staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_RealIdentificationApi");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long api =
        readConstField(
            "api",
            readUnsignedLong(readBuffer, 32),
            PnIoCm_RealIdentificationApi.API,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int numSlots =
        readImplicitField(
            "numSlots",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    List<PnIoCm_RealIdentificationApi_Slot> slots =
        readCountArrayField(
            "slots",
            readComplex(
                () -> PnIoCm_RealIdentificationApi_Slot.staticParse(readBuffer), readBuffer),
            numSlots,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_RealIdentificationApi");
    // Create the instance
    PnIoCm_RealIdentificationApi _pnIoCm_RealIdentificationApi;
    _pnIoCm_RealIdentificationApi = new PnIoCm_RealIdentificationApi(slots);
    return _pnIoCm_RealIdentificationApi;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_RealIdentificationApi)) {
      return false;
    }
    PnIoCm_RealIdentificationApi that = (PnIoCm_RealIdentificationApi) o;
    return (getSlots() == that.getSlots()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getSlots());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
