/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.broker.offset.ConsumerOrderInfoManager;
import org.apache.rocketmq.broker.pop.PopConsumerLockService;
import org.apache.rocketmq.broker.processor.PopMessageProcessor;
import org.apache.rocketmq.broker.processor.PopReviveService;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.BatchAck;
import org.apache.rocketmq.remoting.protocol.body.BatchAckMessageRequestBody;
import org.apache.rocketmq.remoting.protocol.header.AckMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.pop.AckMsg;
import org.apache.rocketmq.store.pop.BatchAckMsg;

public class AckMessageProcessor
implements NettyRequestProcessor {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private final BrokerController brokerController;
    private final String reviveTopic;
    private final PopReviveService[] popReviveServices;

    public AckMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.reviveTopic = PopAckConstants.buildClusterReviveTopic((String)this.brokerController.getBrokerConfig().getBrokerClusterName());
        this.popReviveServices = new PopReviveService[this.brokerController.getBrokerConfig().getReviveQueueNum()];
        for (int i = 0; i < this.brokerController.getBrokerConfig().getReviveQueueNum(); ++i) {
            this.popReviveServices[i] = new PopReviveService(brokerController, this.reviveTopic, i);
            this.popReviveServices[i].setShouldRunPopRevive(brokerController.getBrokerConfig().getBrokerId() == 0L);
        }
    }

    public PopReviveService[] getPopReviveServices() {
        return this.popReviveServices;
    }

    public void shutdown() throws Exception {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.shutdown();
        }
    }

    public void startPopReviveService() {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.start();
        }
    }

    public void shutdownPopReviveService() {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.shutdown();
        }
    }

    public void setPopReviveServiceStatus(boolean shouldStart) {
        for (PopReviveService popReviveService : this.popReviveServices) {
            popReviveService.setShouldRunPopRevive(shouldStart);
        }
    }

    public boolean isPopReviveServiceRunning() {
        for (PopReviveService popReviveService : this.popReviveServices) {
            if (!popReviveService.isShouldRunPopRevive()) continue;
            return true;
        }
        return false;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        return this.processRequest(ctx.channel(), request, true);
    }

    public boolean rejectRequest() {
        return false;
    }

    private RemotingCommand processRequest(Channel channel, RemotingCommand request, boolean brokerAllowSuspend) throws RemotingCommandException {
        BatchAckMessageRequestBody reqBody = null;
        RemotingCommand response = RemotingCommand.createResponseCommand((int)0, null);
        response.setOpaque(request.getOpaque());
        if (request.getCode() == 200051) {
            long maxOffset;
            AckMessageRequestHeader requestHeader = (AckMessageRequestHeader)request.decodeCommandCustomHeader(AckMessageRequestHeader.class);
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
            if (null == topicConfig) {
                POP_LOGGER.error("The topic {} not exist, consumer: {} ", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                response.setCode(17);
                response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
                return response;
            }
            if (requestHeader.getQueueId() >= topicConfig.getReadQueueNums() || requestHeader.getQueueId() < 0) {
                String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
                POP_LOGGER.warn(errorInfo);
                response.setCode(13);
                response.setRemark(errorInfo);
                return response;
            }
            long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
            try {
                maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
            }
            catch (ConsumeQueueException e) {
                throw new RemotingCommandException("Failed to get max offset", (Throwable)e);
            }
            if (requestHeader.getOffset() < minOffset || requestHeader.getOffset() > maxOffset) {
                String errorInfo = String.format("offset is illegal, key:%s@%d, commit:%d, store:%d~%d", requestHeader.getTopic(), requestHeader.getQueueId(), requestHeader.getOffset(), minOffset, maxOffset);
                POP_LOGGER.warn(errorInfo);
                response.setCode(208);
                response.setRemark(errorInfo);
                return response;
            }
            if (this.brokerController.getBrokerConfig().isPopConsumerKVServiceEnable()) {
                this.appendAckNew(requestHeader, null, response, channel, null);
            } else {
                this.appendAck(requestHeader, null, response, channel, null);
            }
        } else if (request.getCode() == 200151) {
            if (request.getBody() != null) {
                reqBody = (BatchAckMessageRequestBody)BatchAckMessageRequestBody.decode((byte[])request.getBody(), BatchAckMessageRequestBody.class);
            }
            if (reqBody == null || reqBody.getAcks() == null || reqBody.getAcks().isEmpty()) {
                response.setCode(208);
                return response;
            }
            for (BatchAck bAck : reqBody.getAcks()) {
                if (this.brokerController.getBrokerConfig().isPopConsumerKVServiceEnable()) {
                    this.appendAckNew(null, bAck, response, channel, reqBody.getBrokerName());
                    continue;
                }
                this.appendAck(null, bAck, response, channel, reqBody.getBrokerName());
            }
        } else {
            POP_LOGGER.error("AckMessageProcessor failed to process RequestCode: {}, consumer: {} ", (Object)request.getCode(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
            response.setCode(13);
            response.setRemark(String.format("AckMessageProcessor failed to process RequestCode: %d", request.getCode()));
            return response;
        }
        return response;
    }

    private void appendAck(AckMessageRequestHeader requestHeader, BatchAck batchAck, RemotingCommand response, Channel channel, String brokerName) throws RemotingCommandException {
        AckMsg ackMsg;
        long invisibleTime;
        long popTime;
        long ackOffset;
        long startOffset;
        int rqId;
        int qId;
        String topic;
        String consumeGroup;
        int ackCount = 0;
        if (batchAck == null) {
            String[] extraInfo = ExtraInfoUtil.split((String)requestHeader.getExtraInfo());
            brokerName = ExtraInfoUtil.getBrokerName((String[])extraInfo);
            consumeGroup = requestHeader.getConsumerGroup();
            topic = requestHeader.getTopic();
            qId = requestHeader.getQueueId();
            rqId = ExtraInfoUtil.getReviveQid((String[])extraInfo);
            startOffset = ExtraInfoUtil.getCkQueueOffset((String[])extraInfo);
            ackOffset = requestHeader.getOffset();
            popTime = ExtraInfoUtil.getPopTime((String[])extraInfo);
            invisibleTime = ExtraInfoUtil.getInvisibleTime((String[])extraInfo);
            if (rqId == 999) {
                this.ackOrderly(topic, consumeGroup, qId, ackOffset, popTime, invisibleTime, channel, response);
                return;
            }
            ackMsg = new AckMsg();
            ackCount = 1;
        } else {
            long maxOffset;
            consumeGroup = batchAck.getConsumerGroup();
            topic = ExtraInfoUtil.getRealTopic((String)batchAck.getTopic(), (String)batchAck.getConsumerGroup(), (String)batchAck.getRetry());
            qId = batchAck.getQueueId();
            rqId = batchAck.getReviveQueueId();
            startOffset = batchAck.getStartOffset();
            ackOffset = -1L;
            popTime = batchAck.getPopTime();
            invisibleTime = batchAck.getInvisibleTime();
            long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, qId);
            try {
                maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, qId);
            }
            catch (ConsumeQueueException e) {
                throw new RemotingCommandException("Failed to get max offset in queue", (Throwable)e);
            }
            if (minOffset == -1L || maxOffset == -1L) {
                POP_LOGGER.error("Illegal topic or queue found when batch ack {}", (Object)batchAck);
                return;
            }
            BatchAckMsg batchAckMsg = new BatchAckMsg();
            BitSet bitSet = batchAck.getBitSet();
            int i = bitSet.nextSetBit(0);
            while (i >= 0 && i != Integer.MAX_VALUE) {
                long offset = startOffset + (long)i;
                if (offset >= minOffset && offset <= maxOffset) {
                    if (rqId == 999) {
                        this.ackOrderly(topic, consumeGroup, qId, offset, popTime, invisibleTime, channel, response);
                    } else {
                        batchAckMsg.getAckOffsetList().add(offset);
                    }
                }
                i = bitSet.nextSetBit(i + 1);
            }
            if (rqId == 999 || batchAckMsg.getAckOffsetList().isEmpty()) {
                return;
            }
            ackMsg = batchAckMsg;
            ackCount = batchAckMsg.getAckOffsetList().size();
        }
        this.brokerController.getBrokerStatsManager().incBrokerAckNums(ackCount);
        this.brokerController.getBrokerStatsManager().incGroupAckNums(consumeGroup, topic, ackCount);
        ackMsg.setConsumerGroup(consumeGroup);
        ackMsg.setTopic(topic);
        ackMsg.setQueueId(qId);
        ackMsg.setStartOffset(startOffset);
        ackMsg.setAckOffset(ackOffset);
        ackMsg.setPopTime(popTime);
        ackMsg.setBrokerName(brokerName);
        if (this.brokerController.getPopMessageProcessor().getPopBufferMergeService().addAk(rqId, ackMsg)) {
            this.brokerController.getPopInflightMessageCounter().decrementInFlightMessageNum(topic, consumeGroup, popTime, qId, ackCount);
            return;
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(this.reviveTopic);
        msgInner.setBody(JSON.toJSONString((Object)ackMsg).getBytes(StandardCharsets.UTF_8));
        msgInner.setQueueId(rqId);
        if (ackMsg instanceof BatchAckMsg) {
            msgInner.setTags("bAck");
            msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genBatchAckUniqueId((BatchAckMsg)ackMsg));
        } else {
            msgInner.setTags("ack");
            msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genAckUniqueId(ackMsg));
        }
        msgInner.setBornTimestamp(System.currentTimeMillis());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setDeliverTimeMs(popTime + invisibleTime);
        msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genAckUniqueId(ackMsg));
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        if (this.brokerController.getBrokerConfig().isAppendAckAsync()) {
            int finalAckCount = ackCount;
            ((CompletableFuture)this.brokerController.getEscapeBridge().asyncPutMessageToSpecificQueue(msgInner).thenAccept(putMessageResult -> this.handlePutMessageResult((PutMessageResult)putMessageResult, ackMsg, topic, consumeGroup, popTime, qId, finalAckCount))).exceptionally(throwable -> {
                this.handlePutMessageResult(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, null, false), ackMsg, topic, consumeGroup, popTime, qId, finalAckCount);
                POP_LOGGER.error("put ack msg error ", throwable);
                return null;
            });
        } else {
            PutMessageResult putMessageResult2 = this.brokerController.getEscapeBridge().putMessageToSpecificQueue(msgInner);
            this.handlePutMessageResult(putMessageResult2, ackMsg, topic, consumeGroup, popTime, qId, ackCount);
        }
    }

    private void appendAckNew(AckMessageRequestHeader requestHeader, BatchAck batchAck, RemotingCommand response, Channel channel, String brokerName) throws RemotingCommandException {
        if (requestHeader != null && batchAck == null) {
            String[] extraInfo = ExtraInfoUtil.split((String)requestHeader.getExtraInfo());
            String groupId = requestHeader.getConsumerGroup();
            String topicId = requestHeader.getTopic();
            int queueId = requestHeader.getQueueId();
            long ackOffset = requestHeader.getOffset();
            long popTime = ExtraInfoUtil.getPopTime((String[])extraInfo);
            long invisibleTime = ExtraInfoUtil.getInvisibleTime((String[])extraInfo);
            int reviveQueueId = ExtraInfoUtil.getReviveQid((String[])extraInfo);
            if (reviveQueueId == 999) {
                this.ackOrderlyNew(topicId, groupId, queueId, ackOffset, popTime, invisibleTime, channel, response);
            } else {
                this.brokerController.getPopConsumerService().ackAsync(popTime, invisibleTime, groupId, topicId, queueId, ackOffset);
            }
            this.brokerController.getBrokerStatsManager().incBrokerAckNums(1);
            this.brokerController.getBrokerStatsManager().incGroupAckNums(groupId, topicId, 1);
        } else {
            String groupId = batchAck.getConsumerGroup();
            String topicId = ExtraInfoUtil.getRealTopic((String)batchAck.getTopic(), (String)batchAck.getConsumerGroup(), (String)batchAck.getRetry());
            int queueId = batchAck.getQueueId();
            int reviveQueueId = batchAck.getReviveQueueId();
            long startOffset = batchAck.getStartOffset();
            long popTime = batchAck.getPopTime();
            long invisibleTime = batchAck.getInvisibleTime();
            try {
                long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(topicId, queueId);
                long maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topicId, queueId);
                if (minOffset == -1L || maxOffset == -1L) {
                    POP_LOGGER.error("Illegal topic or queue found when batch ack {}", (Object)batchAck);
                    return;
                }
                int ackCount = 0;
                BitSet bitSet = batchAck.getBitSet();
                int i = bitSet.nextSetBit(0);
                while (i >= 0 && i != Integer.MAX_VALUE) {
                    long offset = startOffset + (long)i;
                    if (offset >= minOffset && offset <= maxOffset) {
                        if (reviveQueueId == 999) {
                            this.ackOrderlyNew(topicId, groupId, queueId, offset, popTime, invisibleTime, channel, response);
                        } else {
                            this.brokerController.getPopConsumerService().ackAsync(popTime, invisibleTime, groupId, topicId, queueId, offset);
                        }
                        ++ackCount;
                    }
                    i = bitSet.nextSetBit(i + 1);
                }
                this.brokerController.getBrokerStatsManager().incBrokerAckNums(ackCount);
                this.brokerController.getBrokerStatsManager().incGroupAckNums(groupId, topicId, ackCount);
            }
            catch (ConsumeQueueException e) {
                throw new RemotingCommandException("Failed to ack message", (Throwable)e);
            }
        }
    }

    private void handlePutMessageResult(PutMessageResult putMessageResult, AckMsg ackMsg, String topic, String consumeGroup, long popTime, int qId, int ackCount) {
        if (putMessageResult.getPutMessageStatus() != PutMessageStatus.PUT_OK && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_DISK_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.FLUSH_SLAVE_TIMEOUT && putMessageResult.getPutMessageStatus() != PutMessageStatus.SLAVE_NOT_AVAILABLE) {
            POP_LOGGER.error("put ack msg error:" + putMessageResult);
        }
        this.brokerController.getBrokerMetricsManager().getPopMetricsManager().incPopReviveAckPutCount(ackMsg, putMessageResult.getPutMessageStatus());
        this.brokerController.getPopInflightMessageCounter().decrementInFlightMessageNum(topic, consumeGroup, popTime, qId, ackCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ackOrderly(String topic, String consumeGroup, int qId, long ackOffset, long popTime, long invisibleTime, Channel channel, RemotingCommand response) {
        String lockKey = topic + "@" + consumeGroup + "@" + qId;
        long oldOffset = this.brokerController.getConsumerOffsetManager().queryOffset(consumeGroup, topic, qId);
        if (ackOffset < oldOffset) {
            return;
        }
        while (!this.brokerController.getPopMessageProcessor().getQueueLockManager().tryLock(lockKey)) {
        }
        try {
            oldOffset = this.brokerController.getConsumerOffsetManager().queryOffset(consumeGroup, topic, qId);
            if (ackOffset < oldOffset) {
                return;
            }
            long nextOffset = this.brokerController.getConsumerOrderInfoManager().commitAndNext(topic, consumeGroup, qId, ackOffset, popTime);
            if (nextOffset > -1L) {
                if (!this.brokerController.getConsumerOffsetManager().hasOffsetReset(topic, consumeGroup, qId)) {
                    this.brokerController.getConsumerOffsetManager().commitOffset(channel.remoteAddress().toString(), consumeGroup, topic, qId, nextOffset);
                }
                if (!this.brokerController.getConsumerOrderInfoManager().checkBlock(null, topic, consumeGroup, qId, invisibleTime)) {
                    this.brokerController.getPopMessageProcessor().notifyMessageArriving(topic, qId, consumeGroup);
                }
            } else if (nextOffset == -1L) {
                String errorInfo = String.format("offset is illegal, key:%s, old:%d, commit:%d, next:%d, %s", lockKey, oldOffset, ackOffset, nextOffset, channel.remoteAddress());
                POP_LOGGER.warn(errorInfo);
                response.setCode(13);
                response.setRemark(errorInfo);
                return;
            }
        }
        finally {
            this.brokerController.getPopMessageProcessor().getQueueLockManager().unLock(lockKey);
        }
        this.brokerController.getPopInflightMessageCounter().decrementInFlightMessageNum(topic, consumeGroup, popTime, qId, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ackOrderlyNew(String topic, String consumeGroup, int qId, long ackOffset, long popTime, long invisibleTime, Channel channel, RemotingCommand response) {
        ConsumerOffsetManager consumerOffsetManager = this.brokerController.getConsumerOffsetManager();
        ConsumerOrderInfoManager consumerOrderInfoManager = this.brokerController.getConsumerOrderInfoManager();
        PopConsumerLockService consumerLockService = this.brokerController.getPopConsumerService().getConsumerLockService();
        long oldOffset = consumerOffsetManager.queryOffset(consumeGroup, topic, qId);
        if (ackOffset < oldOffset) {
            return;
        }
        while (!consumerLockService.tryLock(consumeGroup, topic)) {
        }
        try {
            oldOffset = consumerOffsetManager.queryOffset(consumeGroup, topic, qId);
            if (ackOffset < oldOffset) {
                return;
            }
            long nextOffset = consumerOrderInfoManager.commitAndNext(topic, consumeGroup, qId, ackOffset, popTime);
            if (this.brokerController.getBrokerConfig().isPopConsumerKVServiceLog()) {
                POP_LOGGER.info("PopConsumerService ack orderly, time={}, topicId={}, groupId={}, queueId={}, offset={}, next={}", new Object[]{popTime, topic, consumeGroup, qId, ackOffset, nextOffset});
            }
            if (nextOffset > -1L) {
                if (!consumerOffsetManager.hasOffsetReset(topic, consumeGroup, qId)) {
                    String remoteAddress = RemotingHelper.parseSocketAddressAddr((SocketAddress)channel.remoteAddress());
                    consumerOffsetManager.commitOffset(remoteAddress, consumeGroup, topic, qId, nextOffset);
                }
                if (!consumerOrderInfoManager.checkBlock(null, topic, consumeGroup, qId, invisibleTime)) {
                    this.brokerController.getPopMessageProcessor().notifyMessageArriving(topic, qId, consumeGroup);
                }
                return;
            }
            if (nextOffset == -1L) {
                String errorInfo = String.format("offset is illegal, key:%s %s %s, old:%d, commit:%d, next:%d, %s", consumeGroup, topic, qId, oldOffset, ackOffset, nextOffset, channel.remoteAddress());
                POP_LOGGER.warn(errorInfo);
                response.setCode(13);
                response.setRemark(errorInfo);
            }
        }
        finally {
            consumerLockService.unlock(consumeGroup, topic);
        }
    }
}

