/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Optional;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.Fill;
import org.apache.sis.style.se1.Font;
import org.apache.sis.style.se1.Halo;
import org.apache.sis.style.se1.LabelPlacement;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.Symbolizer;

@XmlType(name="TextSymbolizerType", propOrder={"label", "font", "labelPlacement", "halo", "fill"})
@XmlRootElement(name="TextSymbolizer")
public class TextSymbolizer<R>
extends Symbolizer<R> {
    @XmlElement(name="Label")
    protected Expression<R, String> label;
    @XmlElement(name="Font")
    protected Font<R> font;
    @XmlElementRef(name="LabelPlacement")
    protected LabelPlacement<R> labelPlacement;
    @XmlElement(name="Halo")
    protected Halo<R> halo;
    @XmlElement(name="Fill")
    protected Fill<R> fill;

    private TextSymbolizer() {
    }

    public TextSymbolizer(StyleFactory<R> factory) {
        super(factory);
    }

    public TextSymbolizer(TextSymbolizer<R> source) {
        super(source);
        this.label = source.label;
        this.font = source.font;
        this.labelPlacement = source.labelPlacement;
        this.halo = source.halo;
        this.fill = source.fill;
    }

    public Expression<R, String> getLabel() {
        return this.label;
    }

    public void setLabel(Expression<R, String> value) {
        this.label = value;
    }

    public Font<R> getFont() {
        if (this.font == null) {
            this.font = this.factory.createFont();
        }
        return this.font;
    }

    public void setFont(Font<R> value) {
        this.font = value;
    }

    public LabelPlacement<R> getLabelPlacement() {
        if (this.labelPlacement == null) {
            this.labelPlacement = this.factory.createPointPlacement();
        }
        return this.labelPlacement;
    }

    public void setLabelPlacement(LabelPlacement<R> value) {
        this.labelPlacement = value;
    }

    public Optional<Halo<R>> getHalo() {
        return Optional.ofNullable(this.halo);
    }

    public void setHalo(Halo<R> value) {
        this.halo = value;
    }

    public Fill<R> getFill() {
        if (this.fill == null) {
            this.fill = this.factory.createFill();
            this.fill.setColor(this.factory.black);
        }
        return this.fill;
    }

    public void setFill(Fill<R> value) {
        this.fill = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.label, this.font, this.labelPlacement, this.halo, this.fill};
    }

    @Override
    public TextSymbolizer<R> clone() {
        TextSymbolizer clone = (TextSymbolizer)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.font != null) {
            this.font = this.font.clone();
        }
        if (this.labelPlacement != null) {
            this.labelPlacement = this.labelPlacement.clone();
        }
        if (this.halo != null) {
            this.halo = this.halo.clone();
        }
        if (this.fill != null) {
            this.fill = this.fill.clone();
        }
    }
}

