/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.io.stream.ChannelData;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.WriteOnlyStorageException;
import org.apache.sis.storage.base.GridResourceWrapper;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.base.URIDataStoreProvider;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.geotiff.Compression;
import org.apache.sis.storage.geotiff.FormatModifier;
import org.apache.sis.storage.geotiff.NativeMetadata;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.Writer;
import org.apache.sis.storage.modifier.CoverageModifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.ListOfUnknownSize;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public class GeoTiffStore
extends DataStore
implements Aggregate {
    final Charset encoding;
    private volatile Reader reader;
    private volatile Writer writer;
    private final Compression compression;
    final Locale dataLocale;
    private final URI location;
    final Path path;
    final NameFactory nameFactory;
    private NameSpace namespace;
    private boolean isNamespaceSet;
    private Metadata metadata;
    private TreeTable nativeMetadata;
    private Components components;
    final boolean hidden;
    final CoverageModifier customizer;

    public GeoTiffStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        this(null, provider, connector, false);
    }

    public GeoTiffStore(DataStore parent, DataStoreProvider provider, StorageConnector connector, boolean hidden) throws DataStoreException {
        super(parent, provider, connector, hidden);
        this.hidden = hidden;
        this.nameFactory = DefaultNameFactory.provider();
        this.customizer = CoverageModifier.getOrDefault((StorageConnector)connector);
        Charset encoding = (Charset)connector.getOption(OptionKey.ENCODING);
        this.encoding = encoding != null ? encoding : StandardCharsets.US_ASCII;
        this.compression = (Compression)connector.getOption(Compression.OPTION_KEY);
        this.dataLocale = (Locale)connector.getOption(OptionKey.LOCALE);
        this.location = (URI)connector.getStorageAs(URI.class);
        this.path = (Path)connector.getStorageAs(Path.class);
        try {
            if (URIDataStoreProvider.isWritable((StorageConnector)connector, (boolean)true)) {
                ChannelDataOutput output = URIDataStoreProvider.openAndSetNativeByteOrder((StorageConnector)connector, (String)"GeoTIFF");
                this.writer = new Writer(this, output, (FormatModifier[])connector.getOption(FormatModifier.OPTION_KEY));
            } else {
                ChannelDataInput input = (ChannelDataInput)connector.commit(ChannelDataInput.class, "GeoTIFF");
                this.reader = new Reader(this, input);
            }
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    private NameSpace namespace() throws DataStoreException {
        assert (Thread.holdsLock((Object)this));
        if (!(this.isNamespaceSet || this.reader == null && this.writer == null)) {
            GenericName name = null;
            if (this.location != null) {
                String filename = ((ChannelData)(this.reader != null ? this.reader.input : this.writer.output)).filename;
                filename = IOUtilities.filenameWithoutExtension((String)filename);
                name = this.nameFactory.createLocalName(null, (CharSequence)filename);
            }
            if ((name = this.customizer.customize(new CoverageModifier.Source((DataStore)this), name)) != null) {
                this.namespace = this.nameFactory.createNameSpace(name, null);
            }
            this.isNamespaceSet = true;
        }
        return this.namespace;
    }

    final GenericName createLocalName(String tip) throws DataStoreException {
        return this.nameFactory.createLocalName(this.namespace(), (CharSequence)tip);
    }

    final StoreListeners listeners() {
        return this.listeners;
    }

    public Optional<ParameterValueGroup> getOpenParameters() {
        Writer w;
        ParameterValueGroup param = URIDataStore.parameters((DataStoreProvider)this.provider, (URI)this.location);
        if (param != null && (w = this.writer) != null) {
            Set<FormatModifier> modifiers = w.getModifiers();
            if (!modifiers.isEmpty()) {
                param.parameter("modifiers").setValue(modifiers.toArray(FormatModifier[]::new));
            }
            if (this.compression != null) {
                param.parameter("compression").setValue((Object)this.compression);
            }
        }
        return Optional.ofNullable(param);
    }

    public Set<FormatModifier> getModifiers() {
        Writer w = this.writer;
        if (w != null) {
            return w.getModifiers();
        }
        Reader r = this.reader;
        if (r != null) {
            return r.getModifiers();
        }
        return Set.of();
    }

    public Optional<Compression> getCompression() {
        return Optional.ofNullable(this.compression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        NameSpace namespace;
        GeoTiffStore geoTiffStore = this;
        synchronized (geoTiffStore) {
            namespace = this.namespace();
        }
        return namespace != null ? Optional.of(namespace.name()) : Optional.empty();
    }

    final void setFormatInfo(MetadataBuilder builder) {
        builder.setPredefinedFormat("GeoTIFF", this.listeners, true);
        builder.addFormatReaderSIS("GeoTIFF");
        builder.addLanguage(Locale.ENGLISH, this.encoding, MetadataBuilder.Scope.METADATA);
        builder.addResourceScope(ScopeCode.valueOf((String)"COVERAGE"), null);
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            Reader reader = this.reader();
            MetadataBuilder builder = new MetadataBuilder();
            this.setFormatInfo(builder);
            int n = 0;
            try {
                GridCoverageResource dir;
                while ((dir = reader.getImage(n++)) != null) {
                    builder.addFromComponent(dir.getMetadata());
                }
            }
            catch (IOException e) {
                throw this.errorIO(e);
            }
            catch (ArithmeticException e) {
                this.listeners.warning((Exception)e);
            }
            this.getIdentifier().ifPresent(id -> {
                builder.addIdentifier(id, MetadataBuilder.Scope.ALL);
                if (!(builder.getTitle() instanceof SimpleInternationalString)) {
                    builder.setTitle((CharSequence)id.toString());
                }
            });
            builder.setISOStandards(true);
            this.metadata = this.customizer.customize(new CoverageModifier.Source((DataStore)this), builder.build());
        }
        return this.metadata;
    }

    public synchronized Optional<TreeTable> getNativeMetadata() throws DataStoreException {
        if (this.nativeMetadata == null) {
            try {
                this.nativeMetadata = new NativeMetadata(this.getLocale()).read(this.reader());
            }
            catch (IOException e) {
                throw this.errorIO(e);
            }
        }
        return Optional.of(this.nativeMetadata);
    }

    public Optional<Resource.FileSet> getFileSet() throws DataStoreException {
        return this.path != null ? Optional.of(new Resource.FileSet(this.path)) : Optional.empty();
    }

    private Reader reader() throws DataStoreException {
        assert (Thread.holdsLock((Object)this));
        Reader r = this.reader;
        if (r == null) {
            if (this.writer != null) {
                throw new WriteOnlyStorageException(this.readOrWriteOnly(1));
            }
            throw new DataStoreClosedException(this.getLocale(), "GeoTIFF", new OpenOption[]{StandardOpenOption.READ});
        }
        return r;
    }

    private Writer writer() throws DataStoreException, IOException {
        assert (Thread.holdsLock((Object)this));
        Reader r = this.reader;
        Writer w = this.writer;
        if (w == null) {
            if (r == null) {
                throw new DataStoreClosedException(this.getLocale(), "GeoTIFF", new OpenOption[]{StandardOpenOption.WRITE});
            }
            this.writer = w = new Writer(r);
        } else if (r != null) {
            w.moveAfterExisting(r);
        }
        return w;
    }

    public synchronized List<GridCoverageResource> components() throws DataStoreException {
        if (this.components == null) {
            this.components = new Components();
        }
        return this.components;
    }

    public synchronized GridCoverageResource findResource(String sequence) throws DataStoreException {
        ArgumentChecks.ensureNonEmpty((String)"sequence", (CharSequence)sequence);
        int index = this.parseImageIndex(sequence);
        if (index >= 0) {
            try {
                GridCoverageResource image = this.reader().getImage(index - 1);
                if (image != null) {
                    return image;
                }
            }
            catch (IOException e) {
                throw this.errorIO(e);
            }
        }
        throw new IllegalNameException(StoreUtilities.resourceNotFound((DataStore)this, (String)sequence));
    }

    private int parseImageIndex(String sequence) throws DataStoreException {
        NameSpace namespace = this.namespace();
        String separator = DefaultNameSpace.getSeparator((NameSpace)namespace, (boolean)false);
        int s = sequence.lastIndexOf(separator);
        if (s >= 0) {
            if (namespace != null) {
                String expected = namespace.name().toString();
                if (!sequence.substring(0, s).equals(expected)) {
                    throw new IllegalNameException(this.errors().getString((short)171, (Object)expected, (Object)sequence));
                }
            }
            sequence = sequence.substring(s + separator.length());
        }
        try {
            return Integer.parseInt(sequence);
        }
        catch (NumberFormatException e) {
            throw new IllegalNameException(StoreUtilities.resourceNotFound((DataStore)this, (String)sequence), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GridCoverageResource append(RenderedImage image, GridGeometry grid, Metadata metadata) throws DataStoreException {
        int index;
        try {
            long offsetIFD;
            Reader reader = this.reader;
            Writer writer = this.writer();
            writer.synchronize(reader, false);
            try {
                offsetIFD = writer.append(image, grid, metadata);
            }
            finally {
                writer.synchronize(reader, true);
            }
            if (reader != null) {
                reader.offsetOfWrittenIFD(offsetIFD);
            }
            index = writer.imageIndex++;
        }
        catch (RasterFormatException | ArithmeticException | IllegalArgumentException e) {
            throw new IncompatibleResourceException(this.cannotWrite(), (Throwable)e).addAspect("raster");
        }
        catch (IOException | RuntimeException e) {
            throw new DataStoreException(this.cannotWrite(), (Throwable)e);
        }
        if (this.components != null) {
            this.components.incrementSize(1);
        }
        return new GridResourceWrapper(this){
            final /* synthetic */ GeoTiffStore this$0;
            {
                this.this$0 = this$0;
            }

            protected Object getSynchronizationLock() {
                return this.this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected GridCoverageResource createSource() throws DataStoreException {
                try {
                    GeoTiffStore geoTiffStore = this.this$0;
                    synchronized (geoTiffStore) {
                        return this.this$0.reader().getImage(index);
                    }
                }
                catch (IOException e) {
                    throw new DataStoreException((Throwable)this.this$0.errorIO(e));
                }
            }
        };
    }

    public GridCoverageResource append(GridCoverage coverage, Metadata metadata) throws DataStoreException {
        return this.append(coverage.render(null), coverage.getGridGeometry(), metadata);
    }

    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    private Errors errors() {
        return Errors.forLocale((Locale)this.getLocale());
    }

    final DataStoreException errorIO(IOException e) {
        return new DataStoreException(this.errors().getString((short)19, (Object)this.getDisplayName()), (Throwable)e);
    }

    private String cannotWrite() {
        return this.errors().getString((short)27, (Object)"GeoTIFF", (Object)this.getDisplayName());
    }

    final String readOrWriteOnly(int mode) {
        return this.errors().getString((short)147, (Object)mode, (Object)this.getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws DataStoreException {
        try {
            this.listeners.close();
            Object r = this.reader;
            Writer w = this.writer;
            if (w != null) {
                w.close();
            }
            if (r != null) {
                r.close();
            }
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
        finally {
            GeoTiffStore geoTiffStore = this;
            synchronized (geoTiffStore) {
                this.components = null;
                this.namespace = null;
                this.metadata = null;
                this.nativeMetadata = null;
                this.reader = null;
                this.writer = null;
            }
        }
    }

    private final class Components
    extends ListOfUnknownSize<GridCoverageResource> {
        private int size = -1;

        Components() {
        }

        protected int characteristics() {
            return 273;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected OptionalInt sizeIfKnown() {
            GeoTiffStore geoTiffStore = GeoTiffStore.this;
            synchronized (geoTiffStore) {
                return this.size >= 0 ? OptionalInt.of(this.size) : OptionalInt.empty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            GeoTiffStore geoTiffStore = GeoTiffStore.this;
            synchronized (geoTiffStore) {
                if (this.size < 0) {
                    this.size = super.size();
                }
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void incrementSize(int n) {
            GeoTiffStore geoTiffStore = GeoTiffStore.this;
            synchronized (geoTiffStore) {
                if (this.size >= 0) {
                    this.size += n;
                }
            }
        }

        protected boolean isValidIndex(int index) {
            return index >= 0 && (this.size >= 0 ? index < this.size : this.getImageFileDirectory(index) != null);
        }

        public GridCoverageResource get(int index) {
            GridCoverageResource image;
            if (index >= 0 && (image = this.getImageFileDirectory(index)) != null) {
                return image;
            }
            throw new IndexOutOfBoundsException(GeoTiffStore.this.errors().getString((short)88, (Object)index));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GridCoverageResource getImageFileDirectory(int index) {
            try {
                GeoTiffStore geoTiffStore = GeoTiffStore.this;
                synchronized (geoTiffStore) {
                    return GeoTiffStore.this.reader().getImage(index);
                }
            }
            catch (IOException e) {
                throw new BackingStoreException((Throwable)GeoTiffStore.this.errorIO(e));
            }
            catch (DataStoreException e) {
                throw new BackingStoreException((Throwable)e);
            }
        }
    }
}

