/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.security.Principal;
import java.util.Set;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.monitor.AuthorizationMonitor;
import org.apache.jackrabbit.oak.security.authorization.permission.MoveAwarePermissionValidator;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidator;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class PermissionValidatorProvider
extends ValidatorProvider {
    private final AuthorizationConfiguration acConfig;
    private final long jr2Permissions;
    private final String workspaceName;
    private final Set<Principal> principals;
    private final MoveTracker moveTracker;
    private final ProviderCtx providerCtx;
    private Context acCtx;
    private Context userCtx;

    public PermissionValidatorProvider(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker, @NotNull ProviderCtx providerCtx) {
        this.acConfig = providerCtx.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class);
        ConfigurationParameters params = this.acConfig.getParameters();
        String compatValue = params.getConfigValue("permissionsJr2", null, String.class);
        this.jr2Permissions = Permissions.getPermissions(compatValue);
        this.workspaceName = workspaceName;
        this.principals = principals;
        this.moveTracker = moveTracker;
        this.providerCtx = providerCtx;
    }

    @Override
    @NotNull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        PermissionProvider pp = this.acConfig.getPermissionProvider(this.createReadOnlyRoot(before), this.workspaceName, this.principals);
        if (this.moveTracker.isEmpty()) {
            return new PermissionValidator(before, after, pp, this);
        }
        return new MoveAwarePermissionValidator(before, after, pp, this, this.moveTracker);
    }

    @NotNull
    Context getAccessControlContext() {
        if (this.acCtx == null) {
            this.acCtx = this.acConfig.getContext();
        }
        return this.acCtx;
    }

    @NotNull
    Context getUserContext() {
        if (this.userCtx == null) {
            UserConfiguration uc = this.providerCtx.getSecurityProvider().getConfiguration(UserConfiguration.class);
            this.userCtx = uc.getContext();
        }
        return this.userCtx;
    }

    @NotNull
    TreeProvider getTreeProvider() {
        return this.providerCtx.getTreeProvider();
    }

    boolean requiresJr2Permissions(long permission) {
        return Permissions.includes(this.jr2Permissions, permission);
    }

    @NotNull
    Root createReadOnlyRoot(@NotNull NodeState nodeState) {
        return this.providerCtx.getRootProvider().createReadOnlyRoot(nodeState);
    }

    @NotNull
    Tree createReadOnlyTree(@NotNull NodeState nodeState) {
        return this.providerCtx.getTreeProvider().createReadOnlyTree(nodeState);
    }

    @NotNull
    AuthorizationMonitor getAccessMonitor() {
        return this.providerCtx.getMonitor();
    }
}

