/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl.style;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.xss.impl.style.BatikCssCleaner;
import org.apache.sling.xss.impl.style.StyleTagProcessor;
import org.apache.sling.xss.impl.xml.AntiSamyPolicy;
import org.owasp.html.AttributePolicy;
import org.owasp.html.HtmlStreamEventProcessor;

public class CssValidator {
    public static final String STYLE_TAG_NAME = "style";
    public static final String STYLE_ATTRIBUTE_NAME = "style";
    private final BatikCssCleaner cssParser;
    private final List<String> disallowedTagNames = new ArrayList<String>();

    public CssValidator(AntiSamyPolicy.CssPolicy cssPolicy) {
        this.cssParser = new BatikCssCleaner(cssPolicy);
    }

    public HtmlStreamEventProcessor newStyleTagProcessor() {
        return new StyleTagProcessor(this.cssParser);
    }

    public AttributePolicy newCssAttributePolicy() {
        return (elementName, attributeName, value) -> this.cssParser.cleanStyleDeclaration(value);
    }

    public List<String> getDisallowedTagNames() {
        return Collections.unmodifiableList(this.disallowedTagNames);
    }
}

