/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core._Java16;
import freemarker.core._Java9;
import freemarker.log.Logger;
import freemarker.template.Version;
import freemarker.template.utility.SecurityUtilities;

public final class _JavaVersions {
    public static final _Java9 JAVA_9 = _JavaVersions.isAtLeast(9, "java.lang.Module") ? _JavaVersions.tryLoadJavaSupportSingleton(9, _Java9.class) : null;
    public static final _Java16 JAVA_16 = _JavaVersions.isAtLeast(16, "java.net.UnixDomainSocketAddress") ? _JavaVersions.tryLoadJavaSupportSingleton(16, _Java16.class) : null;

    private _JavaVersions() {
    }

    private static <T> T tryLoadJavaSupportSingleton(int javaVersion, Class<T> javaSupportInterface) {
        String implClassName = "freemarker.core._Java" + javaVersion + "Impl";
        try {
            return (T)Class.forName(implClassName).getField("INSTANCE").get(null);
        }
        catch (Exception e) {
            try {
                if (e instanceof ClassNotFoundException) {
                    Logger.getLogger("freemarker.runtime").warn("Seems that the Java " + javaVersion + " support class (" + implClassName + ") wasn't included in the build");
                } else {
                    Logger.getLogger("freemarker.runtime").error("Failed to load Java " + javaVersion + " support class", e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static boolean isAtLeast(int minimumMajorVersion, String proofClassPresence) {
        boolean result = false;
        String vStr = SecurityUtilities.getSystemProperty("java.version", null);
        if (vStr != null) {
            try {
                Version v = new Version(vStr);
                result = v.getMajor() >= minimumMajorVersion;
            }
            catch (Exception exception) {}
        } else {
            try {
                Class.forName(proofClassPresence);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

