/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.optimization;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.util.EmptyMemory;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public final class GraphFilterStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final GraphFilterStrategy INSTANCE = new GraphFilterStrategy();

    private GraphFilterStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.getStepsOfAssignableClass(VertexProgramStep.class, traversal).size() > 1) {
            return;
        }
        Graph graph = traversal.getGraph().orElse(EmptyGraph.instance());
        for (TraversalVertexProgramStep step : TraversalHelper.getStepsOfClass(TraversalVertexProgramStep.class, traversal)) {
            Traversal.Admin<Vertex, Edge> edgeFilter;
            Computer computer;
            Traversal.Admin<?, ?> computerTraversal = step.generateProgram(graph, EmptyMemory.instance()).getTraversal().get().clone();
            if (!computerTraversal.isLocked()) {
                computerTraversal.applyStrategies();
            }
            if (null != (computer = step.getComputer()).getEdges() || GraphComputer.Persist.EDGES.equals((Object)computer.getPersist()) || null == (edgeFilter = GraphFilterStrategy.getEdgeFilter(computerTraversal))) continue;
            step.setComputer(computer.edges(edgeFilter));
        }
    }

    protected static Traversal.Admin<Vertex, Edge> getEdgeFilter(Traversal.Admin<?, ?> traversal) {
        String[] boths;
        if (traversal.getStartStep() instanceof GraphStep && ((GraphStep)traversal.getStartStep()).returnsEdge()) {
            return null;
        }
        if (TraversalHelper.hasStepOfAssignableClassRecursively(LambdaHolder.class, traversal)) {
            return null;
        }
        EnumMap directionLabels = new EnumMap(Direction.class);
        HashSet outLabels = new HashSet();
        HashSet inLabels = new HashSet();
        HashSet<String> bothLabels = new HashSet<String>();
        directionLabels.put(Direction.OUT, outLabels);
        directionLabels.put(Direction.IN, inLabels);
        directionLabels.put(Direction.BOTH, bothLabels);
        TraversalHelper.getStepsOfAssignableClassRecursively(VertexStep.class, traversal).forEach(step -> {
            Direction direction = step.getDirection().equals((Object)Direction.IN) && step.returnsEdge() ? Direction.BOTH : step.getDirection();
            String[] edgeLabels = step.getEdgeLabels();
            if (edgeLabels.length == 0) {
                ((Set)directionLabels.get((Object)direction)).add(null);
            } else {
                Collections.addAll((Collection)directionLabels.get((Object)direction), edgeLabels);
            }
        });
        for (String label : outLabels) {
            if (!inLabels.contains(label)) continue;
            bothLabels.add(label);
        }
        if (bothLabels.contains(null)) {
            return null;
        }
        for (String label : bothLabels) {
            outLabels.remove(label);
            inLabels.remove(label);
        }
        if (outLabels.isEmpty() && inLabels.isEmpty() && bothLabels.isEmpty()) {
            return __.bothE(new String[0]).limit(0L).asAdmin();
        }
        String[] ins = inLabels.contains(null) ? new String[]{} : inLabels.toArray(new String[inLabels.size()]);
        String[] outs = outLabels.contains(null) ? new String[]{} : outLabels.toArray(new String[outLabels.size()]);
        String[] stringArray = boths = bothLabels.contains(null) ? new String[]{} : bothLabels.toArray(new String[bothLabels.size()]);
        if (outLabels.isEmpty() && inLabels.isEmpty()) {
            return __.bothE(boths).asAdmin();
        }
        if (inLabels.isEmpty() && bothLabels.isEmpty()) {
            return __.outE(outs).asAdmin();
        }
        if (outLabels.isEmpty() && bothLabels.isEmpty()) {
            return __.inE(ins).asAdmin();
        }
        if (bothLabels.isEmpty()) {
            return __.union(__.inE(ins), __.outE(outs)).asAdmin();
        }
        if (outLabels.isEmpty() && ins.length > 0) {
            return __.union(__.inE(ins), __.bothE(boths)).asAdmin();
        }
        if (inLabels.isEmpty() && outs.length > 0) {
            return __.union(__.outE(outs), __.bothE(boths)).asAdmin();
        }
        return null;
    }

    public static GraphFilterStrategy instance() {
        return INSTANCE;
    }
}

