/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLParameters;
import nl.altindag.ssl.sslparameters.HotSwappableSSLParameters;

public final class SSLParametersUtils {
    private SSLParametersUtils() {
    }

    public static SSLParameters copy(SSLParameters source) {
        if (source instanceof HotSwappableSSLParameters) {
            HotSwappableSSLParameters swappableSslParameters = (HotSwappableSSLParameters)source;
            SSLParameters innerSslParameters = swappableSslParameters.getInnerSslParameters();
            SSLParameters copiedSslParameters = SSLParametersUtils.copy(innerSslParameters);
            swappableSslParameters.setSslParameters(copiedSslParameters);
            return swappableSslParameters;
        }
        SSLParameters target = new SSLParameters();
        target.setProtocols(source.getProtocols());
        target.setCipherSuites(source.getCipherSuites());
        if (source.getWantClientAuth()) {
            target.setWantClientAuth(true);
        }
        if (source.getNeedClientAuth()) {
            target.setNeedClientAuth(true);
        }
        return target;
    }

    public static SSLParameters merge(SSLParameters baseSslParameters, SSLParameters alternativeSslParameters) {
        return SSLParametersUtils.merge(baseSslParameters, alternativeSslParameters, Collections.emptyList(), Collections.emptyList());
    }

    public static SSLParameters merge(SSLParameters baseSslParameters, SSLParameters alternativeSslParameters, List<String> excludedCiphers, List<String> excludedProtocols) {
        boolean needClientAuth;
        boolean wantClientAuth;
        SSLParameters target = new SSLParameters();
        String[] ciphers = Optional.ofNullable(baseSslParameters.getCipherSuites()).filter(array -> ((String[])array).length != 0).orElseGet(alternativeSslParameters::getCipherSuites);
        String[] protocols = Optional.ofNullable(baseSslParameters.getProtocols()).filter(array -> ((String[])array).length != 0).orElseGet(alternativeSslParameters::getProtocols);
        if (!excludedCiphers.isEmpty() && (ciphers = (String[])Arrays.stream(ciphers).filter(cipher -> !excludedCiphers.contains(cipher)).toArray(String[]::new)).length == 0) {
            ciphers = alternativeSslParameters.getCipherSuites();
        }
        if (!excludedProtocols.isEmpty() && (protocols = (String[])Arrays.stream(protocols).filter(cipher -> !excludedProtocols.contains(cipher)).toArray(String[]::new)).length == 0) {
            protocols = alternativeSslParameters.getProtocols();
        }
        target.setCipherSuites(ciphers);
        target.setProtocols(protocols);
        boolean bl = wantClientAuth = baseSslParameters.getWantClientAuth() ? baseSslParameters.getWantClientAuth() : alternativeSslParameters.getWantClientAuth();
        if (wantClientAuth) {
            target.setWantClientAuth(true);
        }
        boolean bl2 = needClientAuth = baseSslParameters.getNeedClientAuth() ? baseSslParameters.getNeedClientAuth() : alternativeSslParameters.getNeedClientAuth();
        if (needClientAuth) {
            target.setNeedClientAuth(true);
        }
        return target;
    }

    public static SSLParameters createSwappableSslParameters(SSLParameters sslParameters) {
        return new HotSwappableSSLParameters(sslParameters);
    }
}

