/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.GValueConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AbstractAddElementStepPlaceholder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;

public abstract class AbstractAddEdgeStepPlaceholder<S>
extends AbstractAddElementStepPlaceholder<S, Edge, Event.EdgeAddedEvent>
implements AddEdgeStepContract<S> {
    protected Traversal.Admin<?, ?> from;
    protected Traversal.Admin<?, ?> to;

    public AbstractAddEdgeStepPlaceholder(Traversal.Admin traversal, String label) {
        super(traversal, label);
    }

    public AbstractAddEdgeStepPlaceholder(Traversal.Admin traversal, GValue<String> label) {
        super(traversal, label);
    }

    public AbstractAddEdgeStepPlaceholder(Traversal.Admin traversal, Traversal.Admin<S, String> labelTraversal) {
        super(traversal, labelTraversal);
    }

    @Override
    protected String getDefaultLabel() {
        return "edge";
    }

    @Override
    public void addTo(Traversal.Admin<?, ?> toObject) {
        this.addTraversal(toObject);
        if (toObject instanceof GValueConstantTraversal) {
            this.traversal.getGValueManager().register(((GValueConstantTraversal)toObject).getGValue());
        }
        this.to = toObject;
        this.integrateChild(this.to);
    }

    @Override
    public void addFrom(Traversal.Admin<?, ?> fromObject) {
        this.addTraversal(fromObject);
        if (fromObject instanceof GValueConstantTraversal) {
            this.traversal.getGValueManager().register(((GValueConstantTraversal)fromObject).getGValue());
        }
        this.from = fromObject;
        this.integrateChild(this.from);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractAddEdgeStepPlaceholder that = (AbstractAddEdgeStepPlaceholder)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.from, this.to);
    }

    @Override
    public boolean isParameterized() {
        return super.isParameterized() || this.from instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.from).isParameterized() || this.to instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.to).isParameterized();
    }

    @Override
    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        List<Traversal.Admin<?, ?>> childTraversals = super.getLocalChildren();
        if (this.from != null) {
            childTraversals.add(this.from instanceof GValueConstantTraversal ? ((GValueConstantTraversal)this.from).getConstantTraversal() : this.from);
        }
        if (this.to != null) {
            childTraversals.add(this.to instanceof GValueConstantTraversal ? ((GValueConstantTraversal)this.to).getConstantTraversal() : this.to);
        }
        return childTraversals;
    }

    @Override
    protected boolean supportsMultiProperties() {
        return false;
    }

    @Override
    public Object getFrom() {
        return this.resolveVertexTraversalAndPinVariables(this.from);
    }

    @Override
    public Object getFromWithGValue() {
        return this.resolveVertexTraversalAndPreserveGValue(this.from);
    }

    @Override
    public Object getTo() {
        return this.resolveVertexTraversalAndPinVariables(this.to);
    }

    @Override
    public Object getToWithGValue() {
        return this.resolveVertexTraversalAndPreserveGValue(this.to);
    }

    @Override
    public void updateVariable(String name, Object value) {
        super.updateVariable(name, value);
        if (this.from instanceof GValueConstantTraversal) {
            ((GValueConstantTraversal)this.from).updateVariable(name, value);
        }
        if (this.to instanceof GValueConstantTraversal) {
            ((GValueConstantTraversal)this.to).updateVariable(name, value);
        }
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        Collection<GValue<?>> gValues = super.getGValues();
        if (this.from instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.from).getGValue().isVariable()) {
            gValues.add(((GValueConstantTraversal)this.from).getGValue());
        }
        if (this.to instanceof GValueConstantTraversal && ((GValueConstantTraversal)this.to).getGValue().isVariable()) {
            gValues.add(((GValueConstantTraversal)this.to).getGValue());
        }
        return gValues;
    }

    @Override
    public AbstractAddEdgeStepPlaceholder<S> clone() {
        AbstractAddEdgeStepPlaceholder clone = (AbstractAddEdgeStepPlaceholder)super.clone();
        if (this.from != null) {
            clone.addFrom(this.from.clone());
        }
        if (this.to != null) {
            clone.addTo(this.to.clone());
        }
        return clone;
    }

    private Object resolveVertexTraversalAndPinVariables(Traversal.Admin<?, ?> vertexTraversal) {
        if (vertexTraversal instanceof GValueConstantTraversal) {
            GValue gValue = ((GValueConstantTraversal)vertexTraversal).getGValue();
            if (gValue.isVariable()) {
                this.traversal.getGValueManager().pinVariable(gValue.getName());
            }
            return new ReferenceVertex(vertexTraversal.next());
        }
        if (vertexTraversal instanceof ConstantTraversal) {
            return new ReferenceVertex(vertexTraversal.next());
        }
        return vertexTraversal;
    }

    private Object resolveVertexTraversalAndPreserveGValue(Traversal.Admin<?, ?> vertexTraversal) {
        if (vertexTraversal instanceof GValueConstantTraversal) {
            return ((GValueConstantTraversal)vertexTraversal).getGValue();
        }
        if (vertexTraversal instanceof ConstantTraversal) {
            return new ReferenceVertex(vertexTraversal.next());
        }
        return vertexTraversal;
    }
}

