/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.identitystore;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@ApplicationScoped
public class TomEEIdentityStoreHandler
implements IdentityStoreHandler {
    @Inject
    private Instance<IdentityStore> identityStores;
    private List<IdentityStore> authenticationStores;
    private List<IdentityStore> authorizationStores;

    @PostConstruct
    private void init() {
        this.authenticationStores = this.identityStores.stream().filter(i -> i.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)).sorted(Comparator.comparing(IdentityStore::priority)).collect(Collectors.toList());
        this.authorizationStores = this.identityStores.stream().filter(i -> i.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS) && !i.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)).sorted(Comparator.comparing(IdentityStore::priority)).collect(Collectors.toList());
    }

    public CredentialValidationResult validate(Credential credential) {
        if (this.authenticationStores.isEmpty()) {
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        CredentialValidationResult validationResult = null;
        IdentityStore authorizedStore = null;
        boolean validationHappened = false;
        for (IdentityStore identityStore : this.authenticationStores) {
            validationResult = identityStore.validate(credential);
            if (validationResult.getStatus().equals((Object)CredentialValidationResult.Status.VALID)) {
                authorizedStore = identityStore;
                validationHappened = true;
                break;
            }
            if (!validationResult.getStatus().equals((Object)CredentialValidationResult.Status.INVALID)) continue;
            validationHappened = true;
        }
        if (authorizedStore == null || !validationResult.getStatus().equals((Object)CredentialValidationResult.Status.VALID)) {
            if (validationHappened) {
                return CredentialValidationResult.INVALID_RESULT;
            }
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        HashSet groups = new HashSet();
        if (authorizedStore.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
            groups.addAll(validationResult.getCallerGroups());
        }
        CredentialValidationResult authorizedValidationResult = validationResult;
        Set additionalGroups = this.authorizationStores.stream().map(as -> as.getCallerGroups(authorizedValidationResult)).flatMap(Collection::stream).collect(Collectors.toSet());
        groups.addAll(additionalGroups);
        return new CredentialValidationResult(authorizedValidationResult.getIdentityStoreId(), authorizedValidationResult.getCallerPrincipal(), authorizedValidationResult.getCallerDn(), authorizedValidationResult.getCallerUniqueId(), groups);
    }
}

