/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.schema.SimpleDriverDataSource;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.util.Closeable;

public class DBCPDriverDataSource
extends SimpleDriverDataSource
implements Configurable,
Closeable {
    private static String DBCPPACKAGENAME = "org.apache.commons.dbcp2";
    private static String DBCPBASICDATASOURCENAME = "org.apache.commons.dbcp2.BasicDataSource";
    private static Class<?> _dbcpClass;
    private static Boolean _dbcpAvail;
    private static RuntimeException _dbcpEx;
    protected JDBCConfiguration conf;
    private volatile DataSource _ds;

    @Override
    public Connection getConnection(Properties props) throws SQLException {
        return this.getDBCPConnection(props);
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this._ds != null && DBCPDriverDataSource.isDBCPLoaded(this.getClassLoader())) {
                ((BasicDataSource)_dbcpClass.cast(this._ds)).close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this._ds = null;
        }
    }

    protected Connection getDBCPConnection(Properties props) throws SQLException {
        Connection con = this.getDBCPDataSource(props).getConnection();
        if (con == null) {
            throw new SQLException(_eloc.get("dbcp-ds-null", DBCPBASICDATASOURCENAME, this.getConnectionDriverName(), this.getConnectionURL()).getMessage());
        }
        return con;
    }

    protected DataSource getDBCPDataSource(Properties props) {
        if (DBCPDriverDataSource.isDBCPLoaded(this.getClassLoader())) {
            if (this._ds == null) {
                try {
                    Properties dbcpProps = this.updateDBCPProperties(props);
                    this._ds = (DataSource)Configurations.newInstance(DBCPBASICDATASOURCENAME, (Configuration)this.conf, dbcpProps, this.getClassLoader());
                }
                catch (Exception e) {
                    _dbcpEx = new RuntimeException(_eloc.get("driver-null", DBCPBASICDATASOURCENAME).getMessage(), e);
                }
                return this._ds;
            }
            return this._ds;
        }
        if (_dbcpEx == null) {
            _dbcpEx = new RuntimeException(_eloc.get("driver-null", DBCPBASICDATASOURCENAME).getMessage());
        }
        throw _dbcpEx;
    }

    protected boolean isDBCPDataSource() {
        return this.getConnectionDriverName() != null && this.getConnectionDriverName().toLowerCase(Locale.ENGLISH).indexOf(DBCPPACKAGENAME) >= 0;
    }

    protected static boolean isDBCPLoaded(ClassLoader cl) {
        if (Boolean.TRUE.equals(_dbcpAvail) && _dbcpClass != null) {
            return true;
        }
        if (Boolean.FALSE.equals(_dbcpAvail)) {
            return false;
        }
        try {
            _dbcpClass = Class.forName(DBCPBASICDATASOURCENAME, true, cl);
            _dbcpAvail = Boolean.TRUE;
            return true;
        }
        catch (Exception e) {
            _dbcpAvail = Boolean.FALSE;
            _dbcpEx = new RuntimeException(_eloc.get("driver-null", DBCPBASICDATASOURCENAME).getMessage(), e);
            return _dbcpAvail;
        }
    }

    private Properties updateDBCPProperties(Properties props) {
        Properties dbcpProps = this.mergeConnectionProperties(props);
        if (this.isDBCPDataSource()) {
            String propDriver = this.hasProperty(dbcpProps, "driverClassName");
            if (propDriver == null || propDriver.trim().isEmpty()) {
                throw new RuntimeException(_eloc.get("connection-property-invalid", "DriverClassName", propDriver).getMessage());
            }
            propDriver = this.hasProperty(dbcpProps, "url");
            if (propDriver == null || propDriver.trim().isEmpty()) {
                throw new RuntimeException(_eloc.get("connection-property-invalid", "URL", propDriver).getMessage());
            }
        } else {
            dbcpProps.setProperty(this.hasKey(dbcpProps, "driverClassName", "driverClassName"), this.getConnectionDriverName());
            dbcpProps.setProperty(this.hasKey(dbcpProps, "url", "url"), this.getConnectionURL());
        }
        if (this.hasKey(dbcpProps, "username") == null) {
            if (this.getConnectionUserName() != null) {
                dbcpProps.setProperty("username", this.getConnectionUserName());
            } else {
                dbcpProps.setProperty("username", "");
            }
        }
        if (this.hasKey(dbcpProps, "password") == null) {
            if (this.getConnectionPassword() != null) {
                dbcpProps.setProperty("password", this.getConnectionPassword());
            } else {
                dbcpProps.setProperty("password", "");
            }
        }
        if (this.hasKey(dbcpProps, "maxActive") == null) {
            dbcpProps.setProperty("maxActive", "10");
        }
        if (this.hasKey(dbcpProps, "maxIdle") == null) {
            dbcpProps.setProperty("maxIdle", dbcpProps.getProperty("maxActive"));
        }
        if (this.hasKey(dbcpProps, "minIdle") == null) {
            dbcpProps.setProperty("minIdle", "0");
        }
        return dbcpProps;
    }

    private Properties mergeConnectionProperties(Properties props) {
        Properties mergedProps = new Properties();
        mergedProps.putAll((Map<?, ?>)this.getConnectionProperties());
        String uid = this.removeProperty(mergedProps, "user");
        if (uid != null) {
            mergedProps.setProperty("username", uid);
        }
        if (props != null && !props.isEmpty()) {
            for (Object o : props.keySet()) {
                String existingKey;
                String key = (String)o;
                String value = props.getProperty(key);
                if ("user".equalsIgnoreCase(key)) {
                    key = "username";
                }
                if ((existingKey = this.hasKey(mergedProps, key)) != null) {
                    mergedProps.setProperty(existingKey, value);
                    continue;
                }
                mergedProps.setProperty(key, value);
            }
        }
        return mergedProps;
    }

    private String hasKey(Properties props, String key) {
        return this.hasKey(props, key, null);
    }

    private String hasKey(Properties props, String key, String defaultKey) {
        if (props != null && key != null) {
            for (Object o : props.keySet()) {
                String entry = (String)o;
                if (!key.equalsIgnoreCase(entry)) continue;
                return entry;
            }
        }
        return defaultKey;
    }

    private String hasProperty(Properties props, String key) {
        String entry;
        if (props != null && key != null && (entry = this.hasKey(props, key)) != null) {
            return props.getProperty(entry);
        }
        return null;
    }

    private String removeProperty(Properties props, String key) {
        String entry;
        if (props != null && key != null && (entry = this.hasKey(props, key)) != null) {
            return (String)props.remove(entry);
        }
        return null;
    }

    @Override
    public void setConfiguration(Configuration conf) {
        if (conf instanceof JDBCConfiguration) {
            this.conf = (JDBCConfiguration)conf;
        }
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
    }
}

