/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.impl;

import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import jakarta.enterprise.concurrent.spi.ThreadContextRestorer;
import jakarta.enterprise.concurrent.spi.ThreadContextSnapshot;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.naming.NamingException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.resource.thread.ManagedExecutorServiceImplFactory;
import org.apache.openejb.threads.future.CUCompletableFuture;
import org.apache.openejb.threads.impl.ManagedExecutorServiceImpl;
import org.apache.openejb.threads.impl.TxThreadContextProvider;
import org.apache.openejb.threads.task.CUTask;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ContextServiceImpl
implements ContextService,
Serializable {
    private final List<ThreadContextProvider> propagated;
    private final List<ThreadContextProvider> cleared;
    private final List<ThreadContextProvider> unchanged;
    private transient ManagedExecutorService mes;
    private static Logger LOG = Logger.getInstance(LogCategory.OPENEJB.createChild("ThreadContext"), "org.apache.openejb.cdi");

    public ContextServiceImpl(List<ThreadContextProvider> propagated, List<ThreadContextProvider> cleared, List<ThreadContextProvider> unchanged) {
        this.propagated = propagated;
        this.cleared = cleared;
        this.unchanged = unchanged;
    }

    public ContextServiceImpl(ContextServiceImpl other, ManagedExecutorService mes) {
        this(other.propagated, other.cleared, other.unchanged);
        this.mes = mes;
    }

    public <R> Callable<R> contextualCallable(Callable<R> callable) {
        return this.createContextualProxy((T)callable, (Class<T>)Callable.class);
    }

    public <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> biConsumer) {
        return this.createContextualProxy((T)biConsumer, (Class<T>)BiConsumer.class);
    }

    public <T> Consumer<T> contextualConsumer(Consumer<T> consumer) {
        return this.createContextualProxy((T)consumer, (Class<T>)Consumer.class);
    }

    public <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> biFunction) {
        return this.createContextualProxy((T)biFunction, (Class<T>)BiFunction.class);
    }

    public <T, R> Function<T, R> contextualFunction(Function<T, R> function) {
        return this.createContextualProxy((T)function, (Class<T>)Function.class);
    }

    public Runnable contextualRunnable(Runnable runnable) {
        return this.createContextualProxy((T)runnable, (Class<T>)Runnable.class);
    }

    public <R> Supplier<R> contextualSupplier(Supplier<R> supplier) {
        return this.createContextualProxy((T)supplier, (Class<T>)Supplier.class);
    }

    public <T> T createContextualProxy(T instance, Class<T> intf) {
        return intf.cast(this.createContextualProxy(instance, new Class[]{intf}));
    }

    public Object createContextualProxy(Object instance, Class<?> ... interfaces) {
        return this.createContextualProxy(instance, Map.of(), interfaces);
    }

    public <T> T createContextualProxy(T instance, Map<String, String> executionProperties, Class<T> intf) {
        return intf.cast(this.createContextualProxy(instance, executionProperties, new Class[]{intf}));
    }

    public Object createContextualProxy(Object instance, Map<String, String> executionProperties, Class<?> ... interfaces) {
        if (instance == null) {
            throw new IllegalArgumentException("Cannot create contextual proxy, instance is null");
        }
        for (Class<?> intf : interfaces) {
            if (intf.isInstance(instance)) continue;
            throw new IllegalArgumentException("Cannot create contextual proxy, instance is not an instance of " + intf.getName());
        }
        return Proxy.newProxyInstance(instance.getClass().getClassLoader(), interfaces, (InvocationHandler)new CUHandler(instance, executionProperties, this));
    }

    public Executor currentContextExecutor() {
        return command -> this.contextualRunnable(command).run();
    }

    public Map<String, String> getExecutionProperties(Object contextualProxy) {
        return ((CUHandler)CUHandler.class.cast((Object)Proxy.getInvocationHandler((Object)contextualProxy))).properties;
    }

    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> completableFuture) {
        return this.copyInternal(completableFuture);
    }

    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> completionStage) {
        return this.copyInternal(completionStage);
    }

    public Snapshot snapshot(Map<String, String> props) {
        ThreadContextSnapshot snapshot;
        boolean appContextPropagated;
        ArrayList<ThreadContextSnapshot> snapshots = new ArrayList<ThreadContextSnapshot>();
        ThreadContextProvider appContext = this.find("Application", this.propagated);
        if (appContext != null) {
            appContextPropagated = true;
        } else {
            appContext = this.find("Application", this.cleared);
            appContextPropagated = false;
        }
        if (appContext != null) {
            if (appContextPropagated) {
                snapshots.add(appContext.currentContext(props));
            } else {
                snapshots.add(appContext.clearedContext(props));
            }
        }
        for (ThreadContextProvider threadContextProvider : this.propagated) {
            if ("Application".equals(threadContextProvider.getThreadContextType())) continue;
            snapshot = threadContextProvider.currentContext(props);
            snapshots.add(snapshot);
        }
        for (ThreadContextProvider threadContextProvider : this.cleared) {
            if ("Application".equals(threadContextProvider.getThreadContextType())) continue;
            snapshot = threadContextProvider.clearedContext(props);
            snapshots.add(snapshot);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContextServiceImpl.snapshot snapshots=" + String.valueOf(snapshots));
        }
        return new Snapshot(snapshots);
    }

    private ThreadContextProvider find(String name, List<ThreadContextProvider> threadContextProviders) {
        for (ThreadContextProvider threadContextProvider : threadContextProviders) {
            if (!name.equals(threadContextProvider.getThreadContextType())) continue;
            return threadContextProvider;
        }
        return null;
    }

    public State enter(Snapshot snapshot) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContextServiceImpl.enter snapshot=" + String.valueOf(snapshot));
        }
        ArrayList<ThreadContextRestorer> restorers = new ArrayList<ThreadContextRestorer>();
        for (ThreadContextSnapshot tcs : snapshot.snapshots()) {
            try {
                restorers.add(0, tcs.begin());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContextServiceImpl.enter restorers=" + String.valueOf(restorers));
        }
        return new State(restorers);
    }

    public void exit(State state) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContextServiceImpl.exit restorers=" + String.valueOf(state.restorers()));
        }
        if (state != null) {
            List<ThreadContextRestorer> restorers = state.restorers();
            for (ThreadContextRestorer restorer : restorers) {
                restorer.endContext();
            }
        }
    }

    private <U> CompletableFuture<U> copyInternal(CompletionStage<U> future) {
        CUCompletableFuture managedFuture = new CUCompletableFuture(this.getManagedExecutorService(), this);
        future.whenComplete((result, exception) -> {
            if (exception == null) {
                managedFuture.complete(result);
            } else {
                managedFuture.completeExceptionally((Throwable)exception);
            }
        });
        return managedFuture;
    }

    protected ManagedExecutorService getManagedExecutorService() {
        if (this.mes == null) {
            try {
                ManagedExecutorServiceImpl defaultMes = ManagedExecutorServiceImplFactory.lookup("java:comp/DefaultManagedExecutorService");
                this.mes = new ManagedExecutorServiceImpl(defaultMes.getDelegate(), this);
            }
            catch (NamingException e) {
                throw new OpenEJBRuntimeException(e);
            }
        }
        return this.mes;
    }

    private static String fromStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static final class CUHandler
    extends CUTask<Object>
    implements InvocationHandler,
    Serializable {
        private final Object instance;
        private final Map<String, String> properties;

        private CUHandler(Object instance, Map<String, String> props, ContextServiceImpl contextService) {
            super(instance, CUHandler.reconfigureContextService(contextService, props), props);
            this.instance = instance;
            this.properties = props;
        }

        private static ContextServiceImpl reconfigureContextService(ContextServiceImpl contextService, Map<String, String> props) {
            if (props == null || !props.containsKey("jakarta.enterprise.concurrent.TRANSACTION")) {
                return contextService;
            }
            ArrayList<ThreadContextProvider> propagated = new ArrayList<ThreadContextProvider>(contextService.propagated);
            ArrayList<ThreadContextProvider> cleared = new ArrayList<ThreadContextProvider>(contextService.cleared);
            ArrayList<ThreadContextProvider> unchanged = new ArrayList<ThreadContextProvider>(contextService.unchanged);
            if ("SUSPEND".equals(props.get("jakarta.enterprise.concurrent.TRANSACTION"))) {
                if (!cleared.contains(TxThreadContextProvider.INSTANCE)) {
                    cleared.add(TxThreadContextProvider.INSTANCE);
                }
                propagated.remove(TxThreadContextProvider.INSTANCE);
                unchanged.remove(TxThreadContextProvider.INSTANCE);
            }
            if ("USE_TRANSACTION_OF_EXECUTION_THREAD".equals(props.get("jakarta.enterprise.concurrent.TRANSACTION"))) {
                if (!propagated.contains(TxThreadContextProvider.INSTANCE)) {
                    propagated.add(TxThreadContextProvider.INSTANCE);
                }
                cleared.remove(TxThreadContextProvider.INSTANCE);
                unchanged.remove(TxThreadContextProvider.INSTANCE);
            }
            return new ContextServiceImpl(new ArrayList<ThreadContextProvider>(propagated), new ArrayList<ThreadContextProvider>(cleared), new ArrayList<ThreadContextProvider>(unchanged));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            return this.invoke(() -> method.invoke(this.instance, args));
        }
    }

    public record Snapshot(List<ThreadContextSnapshot> snapshots) implements Serializable
    {
    }

    public record State(List<ThreadContextRestorer> restorers) {
    }
}

