/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.util.impl.Constants;

@Deprecated(since="3.6.0")
public interface List_of_ints
extends Iterable<Integer> {
    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public boolean contains(int i) {
        return this.indexOf(i) != -1;
    }

    public int[] toArray();

    public int[] toArrayMinCopy();

    public boolean add(int var1);

    public boolean remove(int var1);

    public void clear();

    public int get(int var1);

    public int set(int var1, int var2);

    public void add(int var1, int var2);

    public int removeAtIndex(int var1);

    public int indexOf(int var1);

    public int lastIndexOf(int var1);

    public List_of_ints subList(int var1, int var2);

    public PrimitiveIterator.OfInt iterator();

    public IntListIterator intListIterator();

    public void copyFromArray(int[] var1, int var2, int var3, int var4);

    public void copyToArray(int var1, int[] var2, int var3, int var4);

    public void sort();

    public static List_of_ints EMPTY_LIST() {
        return new List_of_ints(){

            @Override
            public int[] toArray() {
                return Constants.EMPTY_INT_ARRAY;
            }

            @Override
            public int[] toArrayMinCopy() {
                return Constants.EMPTY_INT_ARRAY;
            }

            @Override
            public List_of_ints subList(int fromIndex, int toIndex) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public int set(int index, int element) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int removeAtIndex(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public boolean remove(int i) {
                return false;
            }

            @Override
            public int lastIndexOf(int i) {
                return -1;
            }

            @Override
            public int indexOf(int i) {
                return -1;
            }

            @Override
            public int get(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            public boolean contains(int i) {
                return false;
            }

            @Override
            public void clear() {
            }

            @Override
            public void add(int index, int element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(int i) {
                throw new UnsupportedOperationException();
            }

            @Override
            public PrimitiveIterator.OfInt iterator() {
                return new PrimitiveIterator.OfInt(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public Integer next() {
                        throw new NoSuchElementException();
                    }

                    @Override
                    public int nextInt() {
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            public IntListIterator intListIterator() {
                return new IntListIterator(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public int nextNvc() {
                        throw new IllegalStateException();
                    }

                    @Override
                    public boolean hasPrevious() {
                        return false;
                    }

                    @Override
                    public int previousNvc() {
                        throw new IllegalStateException();
                    }

                    @Override
                    public void moveToStart() {
                    }

                    @Override
                    public void moveToEnd() {
                    }
                };
            }

            @Override
            public void copyFromArray(int[] src, int srcPos, int destPos, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void copyToArray(int srcPos, int[] dest, int destPos, int length) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sort() {
            }
        };
    }

    public static List_of_ints newInstance(int[] ia) {
        return List_of_ints.newInstance(ia, 0, ia.length);
    }

    public static List_of_ints newInstance(final int[] ia, final int start, final int end) {
        return new List_of_ints(){

            @Override
            public int size() {
                return end - start;
            }

            @Override
            public int[] toArray() {
                return Arrays.copyOfRange(ia, start, end);
            }

            @Override
            public int[] toArrayMinCopy() {
                return start == 0 && end == this.size() ? ia : this.toArray();
            }

            @Override
            public boolean add(int i) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(int i) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int get(int index) {
                return ia[start + index];
            }

            @Override
            public int set(int index, int element) {
                int r = this.get(start + index);
                ia[start + index] = element;
                return r;
            }

            @Override
            public void add(int index, int element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int removeAtIndex(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int indexOf(int e) {
                for (int i = start; i < end; ++i) {
                    if (e != ia[i]) continue;
                    return i;
                }
                return -1;
            }

            @Override
            public int lastIndexOf(int e) {
                for (int i = end - 1; i >= start; --i) {
                    if (e != ia[i]) continue;
                    return i;
                }
                return -1;
            }

            @Override
            public List_of_ints subList(int fromIndex, int toIndex) {
                return List_of_ints.newInstance(ia, start + fromIndex, start + toIndex);
            }

            @Override
            public PrimitiveIterator.OfInt iterator() {
                return new PrimitiveIterator.OfInt(){
                    int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < ia.length;
                    }

                    @Override
                    public Integer next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return ia[this.pos++];
                    }

                    @Override
                    public int nextInt() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return ia[this.pos++];
                    }
                };
            }

            @Override
            public IntListIterator intListIterator() {
                return new IntListIterator(){
                    private int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos >= 0 && this.pos < this.size();
                    }

                    @Override
                    public int nextNvc() {
                        return this.get(this.pos++);
                    }

                    @Override
                    public boolean hasPrevious() {
                        return this.pos > 0 && this.pos < this.size();
                    }

                    @Override
                    public int previousNvc() {
                        return this.get(--this.pos);
                    }

                    @Override
                    public void moveToStart() {
                        this.pos = 0;
                    }

                    @Override
                    public void moveToEnd() {
                        this.pos = this.size() - 1;
                    }
                };
            }

            @Override
            public void copyFromArray(int[] src, int srcPos, int destPos, int length) {
                System.arraycopy(src, srcPos, ia, start + destPos, length);
            }

            @Override
            public void copyToArray(int srcPos, int[] dest, int destPos, int length) {
                System.arraycopy(ia, start + srcPos, dest, destPos, length);
            }

            @Override
            public void sort() {
                Arrays.sort(ia, start, end);
            }
        };
    }
}

