/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch;

import java.net.URL;
import java.net.URLClassLoader;

public class ChildFirstClassLoader
extends ClassLoader {
    private ChildFirstURLClassLoader childFirstURLClassLoader;

    public ChildFirstClassLoader(ClassLoader parent, URL[] urls) {
        super(parent);
        this.childFirstURLClassLoader = new ChildFirstURLClassLoader(urls, parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.childFirstURLClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    private static class ChildFirstURLClassLoader
    extends URLClassLoader {
        private ClassLoader parentClassLoader;

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parentClassLoader) {
            super(urls, (ClassLoader)null);
            this.parentClassLoader = parentClassLoader;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.parentClassLoader.loadClass(name);
            }
        }
    }
}

