/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.patches;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Patch;
import org.apache.unomi.api.services.PatchService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchServiceImpl
implements PatchService,
SynchronousBundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PatchServiceImpl.class.getName());
    private BundleContext bundleContext;
    private PersistenceService persistenceService;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void postConstruct() {
        LOGGER.debug("postConstruct {{}}", (Object)this.bundleContext.getBundle());
        this.processBundleStartup(this.bundleContext);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null || bundle.getBundleId() == this.bundleContext.getBundle().getBundleId()) continue;
            this.processBundleStartup(bundle.getBundleContext());
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        LOGGER.info("Patch service initialized.");
    }

    public void preDestroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        LOGGER.info("Patch service shutdown.");
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 2) {
            this.processBundleStartup(event.getBundle().getBundleContext());
        }
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.loadPredefinedPatches(bundleContext);
    }

    private void loadPredefinedPatches(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        Enumeration urls = bundleContext.getBundle().findEntries("META-INF/cxs/patches", "*.json", true);
        if (urls != null) {
            ArrayList<URL> resources = Collections.list(urls);
            resources.sort(new Comparator<URL>(){

                @Override
                public int compare(URL o1, URL o2) {
                    return o1.getFile().compareTo(o2.getFile());
                }
            });
            for (URL patchUrl : resources) {
                try {
                    Patch patch = (Patch)CustomObjectMapper.getObjectMapper().readValue(patchUrl, Patch.class);
                    if (this.persistenceService.load(patch.getItemId(), Patch.class) != null) continue;
                    this.patch(patch);
                }
                catch (IOException e) {
                    LOGGER.error("Error while loading patch {}", (Object)patchUrl, (Object)e);
                }
            }
        }
    }

    public Patch load(String id) {
        return (Patch)this.persistenceService.load(id, Patch.class);
    }

    public Item patch(Patch patch) {
        Class type = (Class)Patch.PATCHABLE_TYPES.get(patch.getPatchedItemType());
        if (type == null) {
            throw new IllegalArgumentException("Must specify valid type");
        }
        Item item = this.persistenceService.load(patch.getPatchedItemId(), type);
        if (item != null && patch.getOperation() != null) {
            LOGGER.info("Applying patch {}", (Object)patch.getItemId());
            switch (patch.getOperation()) {
                case "override": {
                    item = (Item)CustomObjectMapper.getObjectMapper().convertValue(patch.getData(), type);
                    this.persistenceService.save(item);
                    break;
                }
                case "patch": {
                    JsonNode node = CustomObjectMapper.getObjectMapper().valueToTree((Object)item);
                    JsonPatch jsonPatch = (JsonPatch)CustomObjectMapper.getObjectMapper().convertValue(patch.getData(), JsonPatch.class);
                    try {
                        JsonNode converted = jsonPatch.apply(node);
                        item = (Item)CustomObjectMapper.getObjectMapper().convertValue((Object)converted, type);
                        this.persistenceService.save(item);
                    }
                    catch (JsonPatchException e) {
                        LOGGER.error("Cannot apply patch", (Throwable)e);
                    }
                    break;
                }
                case "remove": {
                    this.persistenceService.remove(patch.getPatchedItemId(), type);
                }
            }
        }
        patch.setLastApplication(new Date());
        this.persistenceService.save((Item)patch);
        return item;
    }
}

