/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Retriever;
import co.elastic.clients.elasticsearch._types.RetrieverBase;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RRFRetriever
extends RetrieverBase
implements RetrieverVariant {
    private final List<Retriever> retrievers;
    @Nullable
    private final Integer rankConstant;
    @Nullable
    private final Integer rankWindowSize;
    @Nullable
    private final String query;
    private final List<String> fields;
    public static final JsonpDeserializer<RRFRetriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RRFRetriever::setupRRFRetrieverDeserializer);

    private RRFRetriever(Builder builder) {
        super(builder);
        this.retrievers = ApiTypeHelper.unmodifiableRequired(builder.retrievers, (Object)this, "retrievers");
        this.rankConstant = builder.rankConstant;
        this.rankWindowSize = builder.rankWindowSize;
        this.query = builder.query;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
    }

    public static RRFRetriever of(Function<Builder, ObjectBuilder<RRFRetriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Retriever.Kind _retrieverKind() {
        return Retriever.Kind.Rrf;
    }

    public final List<Retriever> retrievers() {
        return this.retrievers;
    }

    @Nullable
    public final Integer rankConstant() {
        return this.rankConstant;
    }

    @Nullable
    public final Integer rankWindowSize() {
        return this.rankWindowSize;
    }

    @Nullable
    public final String query() {
        return this.query;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.retrievers)) {
            generator.writeKey("retrievers");
            generator.writeStartArray();
            for (Retriever retriever : this.retrievers) {
                retriever.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.rankConstant != null) {
            generator.writeKey("rank_constant");
            generator.write(this.rankConstant.intValue());
        }
        if (this.rankWindowSize != null) {
            generator.writeKey("rank_window_size");
            generator.write(this.rankWindowSize.intValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            generator.write(this.query);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRRFRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        RetrieverBase.setupRetrieverBaseDeserializer(op);
        op.add(Builder::retrievers, JsonpDeserializer.arrayDeserializer(Retriever._DESERIALIZER), "retrievers");
        op.add(Builder::rankConstant, JsonpDeserializer.integerDeserializer(), "rank_constant");
        op.add(Builder::rankWindowSize, JsonpDeserializer.integerDeserializer(), "rank_window_size");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)JsonpDeserializer.stringDeserializer()), "fields");
    }

    public static class Builder
    extends RetrieverBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RRFRetriever> {
        private List<Retriever> retrievers;
        @Nullable
        private Integer rankConstant;
        @Nullable
        private Integer rankWindowSize;
        @Nullable
        private String query;
        @Nullable
        private List<String> fields;

        public final Builder retrievers(List<Retriever> list) {
            this.retrievers = Builder._listAddAll(this.retrievers, list);
            return this;
        }

        public final Builder retrievers(Retriever value, Retriever ... values) {
            this.retrievers = Builder._listAdd(this.retrievers, value, values);
            return this;
        }

        public final Builder retrievers(RetrieverVariant value, RetrieverVariant ... values) {
            this.retrievers = Builder._listAdd(this.retrievers, value._toRetriever(), new Retriever[0]);
            for (RetrieverVariant v : values) {
                Builder._listAdd(this.retrievers, v._toRetriever(), new Retriever[0]);
            }
            return this;
        }

        public final Builder retrievers(Function<Retriever.Builder, ObjectBuilder<Retriever>> fn) {
            return this.retrievers(fn.apply(new Retriever.Builder()).build(), new Retriever[0]);
        }

        public final Builder rankConstant(@Nullable Integer value) {
            this.rankConstant = value;
            return this;
        }

        public final Builder rankWindowSize(@Nullable Integer value) {
            this.rankWindowSize = value;
            return this;
        }

        public final Builder query(@Nullable String value) {
            this.query = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RRFRetriever build() {
            this._checkSingleUse();
            return new RRFRetriever(this);
        }
    }
}

