/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.groovy.actions;

import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyBundleResourceConnector
implements ResourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GroovyBundleResourceConnector.class.getName());
    private BundleContext bundleContext;

    public GroovyBundleResourceConnector(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public URLConnection getResourceConnection(String resourcePath) throws ResourceException {
        File resourceFile;
        File resourcesSourceFolder;
        File moduleSourceFolder;
        URL resourceURL = null;
        Dictionary headers = this.bundleContext.getBundle().getHeaders();
        if (headers.get("Unomi-Source-Folders") != null && (moduleSourceFolder = new File((String)headers.get("Unomi-Source-Folders"))).exists() && (resourcesSourceFolder = new File(moduleSourceFolder, "src/main/resources")).exists() && (resourceFile = new File(resourcesSourceFolder, resourcePath)).exists()) {
            try {
                LOGGER.info("Loading file {} from module source !", (Object)resourcePath);
                resourceURL = resourceFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Error loading file {} from module source code", (Object)resourcePath, (Object)e);
            }
        }
        if (resourceURL == null && (resourceURL = this.bundleContext.getBundle().getEntry(resourcePath)) == null) {
            throw new ResourceException("Could find Groovy resource " + resourcePath);
        }
        try {
            return resourceURL.openConnection();
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
    }
}

