/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.OtherAttributesAware;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.StringHelper;

@Metadata(label="eip,routing")
@XmlType(name="loadBalancer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoadBalancerDefinition
extends IdentifiedType
implements OtherAttributesAware {
    @XmlTransient
    private LoadBalancer loadBalancer;
    @XmlTransient
    private String loadBalancerTypeName;
    @XmlAnyAttribute
    private Map<QName, Object> otherAttributes;

    public LoadBalancerDefinition() {
    }

    public LoadBalancerDefinition(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    protected LoadBalancerDefinition(String loadBalancerTypeName) {
        this.loadBalancerTypeName = loadBalancerTypeName;
    }

    protected void setProperty(Object bean, String name, Object value) {
        try {
            IntrospectionSupport.setProperty(bean, name, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property " + name + " on " + bean + ". Reason: " + e, e);
        }
    }

    protected int getMaximumNumberOfOutputs() {
        return Integer.MAX_VALUE;
    }

    protected void configureLoadBalancer(LoadBalancer loadBalancer) {
    }

    public LoadBalancer getLoadBalancer(RouteContext routeContext) {
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    @Override
    public Map<QName, Object> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    public void setOtherAttributes(Map<QName, Object> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    protected LoadBalancer createLoadBalancer(RouteContext routeContext) {
        StringHelper.notEmpty(this.loadBalancerTypeName, "loadBalancerTypeName", this);
        LoadBalancer answer = null;
        if (this.loadBalancerTypeName != null) {
            Class<LoadBalancer> type = routeContext.getCamelContext().getClassResolver().resolveClass(this.loadBalancerTypeName, LoadBalancer.class);
            if (type == null) {
                throw new IllegalArgumentException("Cannot find class: " + this.loadBalancerTypeName + " in the classpath");
            }
            answer = routeContext.getCamelContext().getInjector().newInstance(type);
            this.configureLoadBalancer(answer);
        }
        return answer;
    }

    public String toString() {
        if (this.loadBalancer != null) {
            return this.loadBalancer.toString();
        }
        return this.loadBalancerTypeName;
    }
}

