/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.pageStore.DefaultPageContext;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.util.lang.Args;

public class PageManager
implements IPageManager {
    private final IPageStore store;

    public PageManager(IPageStore store) {
        this.store = Args.notNull(store, "store");
    }

    @Override
    public boolean supportsVersioning() {
        return this.store.supportsVersioning();
    }

    @Override
    public IManageablePage getPage(int pageId) {
        IPageContext context = this.createPageContext();
        IManageablePage page = this.store.getPage(context, pageId);
        if (page != null) {
            this.store.addPage(context, page);
        }
        return page;
    }

    @Override
    public void removePage(IManageablePage page) {
        this.store.removePage(this.createPageContext(), page);
    }

    @Override
    public void touchPage(IManageablePage page) {
        this.store.addPage(this.createPageContext(), page);
    }

    @Override
    public void clear() {
        this.store.removeAllPages(this.createPageContext());
    }

    @Override
    public void untouchPage(IManageablePage page) {
        this.store.revertPage(this.createPageContext(), page);
    }

    @Override
    public void end() {
        this.store.end(this.createPageContext());
    }

    @Override
    public void detach() {
        this.store.detach(this.createPageContext());
    }

    protected IPageContext createPageContext() {
        return new DefaultPageContext();
    }

    @Override
    public void destroy() {
        this.store.destroy();
    }

    @Override
    public IPageStore getPageStore() {
        return this.store;
    }
}

