/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching;

import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.ResourceUrl;
import org.apache.wicket.request.resource.caching.version.CachingResourceVersion;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.StringValue;

public class QueryStringWithVersionResourceCachingStrategy
implements IResourceCachingStrategy {
    private static final String DEFAULT_VERSION_PARAMETER = "ver";
    private final String versionParameter;
    private final IResourceVersion resourceVersion;

    public QueryStringWithVersionResourceCachingStrategy(IResourceVersion resourceVersion) {
        this(DEFAULT_VERSION_PARAMETER, resourceVersion);
    }

    public QueryStringWithVersionResourceCachingStrategy(String versionParameter, IResourceVersion resourceVersion) {
        this.versionParameter = Args.notEmpty(versionParameter, "versionParameter");
        this.resourceVersion = Args.notNull(resourceVersion, "resourceVersion");
    }

    public final String getVersionParameter() {
        return this.versionParameter;
    }

    @Override
    public void decorateUrl(ResourceUrl url, IStaticCacheableResource resource) {
        String version = this.resourceVersion.getVersion(resource);
        if (version != null) {
            url.getParameters().set(this.versionParameter, version, INamedParameters.Type.MANUAL);
        }
    }

    @Override
    public void undecorateUrl(ResourceUrl url) {
        INamedParameters parameters = url.getParameters();
        if (parameters != null) {
            StringValue versionValue = parameters.get(this.versionParameter);
            RequestCycle requestCycle = RequestCycle.get();
            if (!versionValue.isEmpty() && requestCycle != null) {
                requestCycle.setMetaData(URL_VERSION, versionValue.toString());
            }
            parameters.remove(this.versionParameter, new String[0]);
        }
    }

    @Override
    public void decorateResponse(AbstractResource.ResourceResponse response, IStaticCacheableResource resource) {
        String requestedVersion = (String)RequestCycle.get().getMetaData(URL_VERSION);
        String calculatedVersion = this.resourceVersion.getVersion(resource);
        if (calculatedVersion != null && calculatedVersion.equals(requestedVersion)) {
            response.setCacheDurationToMaximum();
            response.setCacheScope(WebResponse.CacheScope.PUBLIC);
        }
    }

    @Override
    public void clearCache() {
        if (this.resourceVersion instanceof CachingResourceVersion) {
            ((CachingResourceVersion)this.resourceVersion).invalidateAll();
        }
    }
}

