/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;
import org.qtproject.qt5.android.QtNativeInputConnection;

public class EditPopupMenu
implements ViewTreeObserver.OnPreDrawListener,
View.OnClickListener {
    private View m_layout = null;
    private View m_view = null;
    private PopupWindow m_popup = null;
    private Activity m_activity;
    private int m_posX;
    private int m_posY;

    public EditPopupMenu(Activity activity, View view) {
        this.m_activity = activity;
        this.m_layout = view;
    }

    private boolean initOverlay() {
        if (this.m_popup == null) {
            Context context = this.m_layout.getContext();
            int[] nArray = new int[]{16843540};
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(nArray);
            int n = typedArray.getResourceId(0, 0);
            LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.m_view = layoutInflater.inflate(n, null);
            int n2 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.m_view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            this.m_view.measure(n2, n2);
            this.m_view.setOnClickListener((View.OnClickListener)this);
            this.m_popup = new PopupWindow(context, null, 16843464);
            this.m_popup.setSplitTouchEnabled(true);
            this.m_popup.setClippingEnabled(false);
            this.m_popup.setContentView(this.m_view);
            this.m_popup.setWidth(-2);
            this.m_popup.setHeight(-2);
            this.m_layout.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        return true;
    }

    public int getHeight() {
        this.initOverlay();
        return this.m_view.getHeight();
    }

    public void setPosition(int n, int n2) {
        this.initOverlay();
        int[] nArray = new int[2];
        this.m_layout.getLocationOnScreen(nArray);
        int n3 = n + nArray[0];
        int n4 = n2 + nArray[1];
        if ((n3 -= this.m_view.getWidth() / 2) < 0) {
            n3 = 0;
        }
        n4 -= this.m_view.getHeight();
        if (this.m_popup.isShowing()) {
            this.m_popup.update(n3, n4, -1, -1);
        } else {
            this.m_popup.showAtLocation(this.m_layout, 0, n3, n4);
        }
        this.m_posX = n;
        this.m_posY = n2;
    }

    public void hide() {
        if (this.m_popup != null) {
            this.m_popup.dismiss();
        }
    }

    public boolean onPreDraw() {
        if (this.m_popup != null && this.m_popup.isShowing()) {
            this.setPosition(this.m_posX, this.m_posY);
        }
        return true;
    }

    public void onClick(View view) {
        QtNativeInputConnection.paste();
        this.hide();
    }
}

