/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

import QtQuick 2.0

ListModel {
    function resolveUrl(source)
    {
        if (typeof(source) === "undefined")
            return ""
        return Qt.resolvedUrl(source)
    }

    ListElement {
        displayName: "Getting Started with Qt Design Studio"
        thumbnail: "images/Course-GettingStarted-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#getting-started-with-qt-design-studio"
        showTutorial: true
        tagData: "Overview, Workflow"
        description: "Our course, Getting Started with Qt Design Studio, is the second module in our FYI Frontend Learning Track, Getting Started With UI Design."
    }

    ListElement {
        displayName: "How to Use Qt Bridge for Figma"
        thumbnail: "images/Course-QtBridge-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#how-to-use-qt-bridge-for-figma"
        showTutorial: true
        tagData: "Overview, Workflow, Qt Bridge"
        description: "Understand how Figma can be used as an external design tool and how these designs can progress from wireframe to prototype with the help of the Qt Bridge plugin for Figma."
    }

    ListElement {
        displayName: "Basic Views in Qt Design Studio"
        thumbnail: "images/Course-BasicViews-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#basic-views-in-qt-design-studio"
        showTutorial: true
        tagData: "Overview, Workflow"
        description: "In this course, you'll get a basic understanding of Qt Design Studio UI, its tools and different workspaces. By the end of this course, you will have an understanding on how to navigate in Qt Design Studio."
    }

    ListElement {
        displayName: "Fundamental Concepts in Qt Design Studio"
        thumbnail: "images/Course-Fundamental Concepts-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#fundamental-concepts-in-qt-design-studio"
        showTutorial: true
        tagData: "Overview, Workflow"
        description: "In this course, you'll get a better understanding of different properties and familiarize yourself with components and assets. You'll also learn, how to use the states view in Qt Design Studio."
    }

    ListElement {
        displayName: "Project Structure in Qt Design Studio"
        thumbnail: "images/Course-ProjectStructure-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#project-structure-in-qt-design-studio"
        showTutorial: true
        tagData: "Overview, Workflow"
        description: "In this course, you'll get a basic understanding of the QML project structure and learn the difference between declarative and imperative programming styles. You'll also familiarize yourself with App.qml and UI files, and learn how to change different settings with Constants.qml file."
    }

    ListElement {
        displayName: "Multiple Screens in Qt Design Studio"
        thumbnail: "images/Course-MultipleScreens-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#multiple-screens-in-qt-design-studio"
        showTutorial: true
        tagData: "Overview, Workflow"
        description: "In this course, you'll learn how to create additional screens in Qt Design Studio. By the end of this course, you will also have an understanding on how to add transitions, animations and logic and view the outcome in Qt Design Studio."
    }

    ListElement {
        displayName: "2D with Qt Design Studio"
        thumbnail: "images/Course-2D-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#2d-with-qt-design-studio"
        showTutorial: true
        tagData: "Overview, Workflow"
        description: "In this course, we go through the fundamentals of composing a 2D user interface with Qt Design Studio."
    }

    ListElement {
        displayName: "3D with Qt Design Studio"
        thumbnail: "images/Course-2D-QDS-1.png"
        url: "https://www.qt.io/academy/course-catalog#3d-with-qt-design-studio"
        showTutorial: true
        tagData: "Overview, Workflow"
        description: "In this course, you will learn the basics of how to get started with 3D UI design in Qt Design Studio."
    }

    ListElement {
        displayName: "Creating Your First App with Qt Design Studio"
        thumbnail: "images/Course-FirstApp-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#creating-your-first-app-with-qt-design-studio"
        showTutorial: true
        tagData: "Overview, Workflow"
        description: "In this course, you'll learn how to create your first application with Qt. Note that you need to have Qt Design Studio installed on your computer to get the most out of this course."
    }

    ListElement {
        displayName: "Qt Design Studio: Blur Effect"
        thumbnail: "images/Blur-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#qt-design-studio:-blur-effect"
        showTutorial: true
        tagData: "Workflow"
        description: "In this video tutorial, you will learn the basic use of the blur effect from QtQuick.Effects library."
    }

    ListElement {
        displayName: "Qt Design Studio: Recapping the Basics"
        thumbnail: "images/Path-UIDesign-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#qt-design-studio:-recapping-the-basics"
        showTutorial: true
        tagData: "Overview, Recap"
        description: "In this learning path, you will get a comprehensive understanding of Qt Design Studio UI, its tools and different workspaces. You'll also familiarize yourself with various topics from properties, components and assets to QML project structure and finally to creating additional screens and animations to them. This learning path consists of four courses."
    }
    ListElement {
        displayName: "UI Design with Qt Design Studio"
        thumbnail: "images/Path-Basics-QDS.png"
        url: "https://www.qt.io/academy/course-catalog#ui-design-with-qt-design-studio"
        showTutorial: true
        tagData: "Design"
        description: "UI with Qt Design Studio has been designed to help you on your journey to becoming a UI designer and utilising Qt Framework to create experiences with Qt Design Studio."
    }
}
